"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudProviderIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../common/utils/helpers");
var _google_cloud_logo = _interopRequireDefault(require("../assets/icons/google_cloud_logo.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_provider_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCloudProviderIcon = cloudProvider => {
  switch (cloudProvider.toLowerCase()) {
    case 'azure':
      return 'logoAzure';
    case 'aws':
      return 'logoAWS';
    case 'gcp':
      return _google_cloud_logo.default;
    default:
      return undefined;
  }
};
const CloudProviderIcon = ({
  cloudProvider,
  size,
  style
}) => {
  const iconType = getCloudProviderIcon(cloudProvider);
  if (!iconType) {
    return null;
  }
  const name = (0, _helpers.getCloudProviderNameFromAbbreviation)(cloudProvider);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: name,
    type: iconType,
    size: size || 'xl',
    css: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 10
    }
  });
};
exports.CloudProviderIcon = CloudProviderIcon;