"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _std = require("@kbn/std");
var _camelcaseKeys = _interopRequireDefault(require("camelcase-keys"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _collectors = require("./collectors");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _parse_onboarding_default_solution = require("../common/parse_onboarding_default_solution");
var _utils = require("../common/utils");
var _env = require("./env");
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
var _cloud_data = require("./cloud_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Setup contract
 */

/**
 * Start contract
 */

class CloudPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "trialEndDate", void 0);
    this.context = context;
    this.config = this.context.config.get();
    this.logger = this.context.logger.get();
    this.trialEndDate = this.config.trial_end_date ? new Date(this.config.trial_end_date) : undefined;
  }
  setup(core, {
    usageCollection
  }) {
    var _this$config$serverle, _this$config$serverle2, _this$config$serverle3, _this$config$serverle4, _this$config$serverle5, _decodedId, _decodedId2, _decodedId3, _decodedId4, _this$config$apm, _this$config$apm2, _this$config$onboardi2, _this$config$serverle6, _this$config$serverle7;
    const isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    const organizationId = this.config.organization_id;
    const projectId = (_this$config$serverle = this.config.serverless) === null || _this$config$serverle === void 0 ? void 0 : _this$config$serverle.project_id;
    const projectType = (_this$config$serverle2 = this.config.serverless) === null || _this$config$serverle2 === void 0 ? void 0 : _this$config$serverle2.project_type;
    const productTier = (_this$config$serverle3 = this.config.serverless) === null || _this$config$serverle3 === void 0 ? void 0 : _this$config$serverle3.product_tier;
    const orchestratorTarget = (_this$config$serverle4 = this.config.serverless) === null || _this$config$serverle4 === void 0 ? void 0 : _this$config$serverle4.orchestrator_target;
    const isServerlessEnabled = !!projectId;
    const deploymentId = (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url);
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    (0, _collectors.registerCloudUsageCollector)(usageCollection, {
      isCloudEnabled,
      organizationId,
      trialEndDate: this.config.trial_end_date,
      isElasticStaffOwned: this.config.is_elastic_staff_owned,
      deploymentId,
      projectId,
      projectType,
      productTier,
      orchestratorTarget,
      organizationInTrial: (_this$config$serverle5 = this.config.serverless) === null || _this$config$serverle5 === void 0 ? void 0 : _this$config$serverle5.in_trial
    });
    const basePath = core.http.basePath.serverBasePath;
    core.http.resources.register({
      path: '/app/cloud/onboarding',
      validate: {
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          next: _configSchema.schema.maybe(_configSchema.schema.string()),
          onboarding_token: _configSchema.schema.maybe(_configSchema.schema.string()),
          security: _configSchema.schema.maybe(_configSchema.schema.object({
            use_case: _configSchema.schema.oneOf([_configSchema.schema.literal('siem'), _configSchema.schema.literal('cloud'), _configSchema.schema.literal('edr'), _configSchema.schema.literal('other')]),
            migration: _configSchema.schema.maybe(_configSchema.schema.object({
              value: _configSchema.schema.boolean(),
              type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('splunk'), _configSchema.schema.literal('other')]))
            }))
          })),
          resource_data: _configSchema.schema.maybe(_configSchema.schema.object({
            project: _configSchema.schema.maybe(_configSchema.schema.object({
              search: _configSchema.schema.maybe(_configSchema.schema.object({
                type: _configSchema.schema.oneOf([_configSchema.schema.literal('general'), _configSchema.schema.literal('vector'), _configSchema.schema.literal('timeseries')])
              }))
            })),
            deployment: _configSchema.schema.maybe(_configSchema.schema.object({
              id: _configSchema.schema.maybe(_configSchema.schema.string()),
              name: _configSchema.schema.maybe(_configSchema.schema.string())
            }))
          }))
        }, {
          unknowns: 'ignore'
        }))
      },
      security: {
        authz: {
          enabled: false,
          reason: 'Authorization at the API level isn’t required, as it’s implicitly enforced by the scoped `uiSettings` and `SavedObjects` clients used to handle the request.'
        }
      }
    }, async (context, request, response) => {
      var _request$query$onboar, _request$query, _request$query$securi, _request$query2, _request$query$resour, _request$query3, _this$config$onboardi;
      const {
        uiSettings
      } = await context.core;
      const defaultRoute = await uiSettings.client.get('defaultRoute', {
        request
      });
      const nextCandidateRoute = (0, _std.parseNextURL)(request.url.href);
      const route = nextCandidateRoute === '/' ? defaultRoute : nextCandidateRoute;
      // need to get rid of ../../ to make sure we will not be out of space basePath
      const normalizedRoute = new URL(route, 'https://localhost');
      const queryOnboardingToken = (_request$query$onboar = (_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.onboarding_token) !== null && _request$query$onboar !== void 0 ? _request$query$onboar : undefined;
      const queryOnboardingSecurityRaw = (_request$query$securi = (_request$query2 = request.query) === null || _request$query2 === void 0 ? void 0 : _request$query2.security) !== null && _request$query$securi !== void 0 ? _request$query$securi : undefined;
      const queryOnboardingSecurity = queryOnboardingSecurityRaw ? (0, _camelcaseKeys.default)(queryOnboardingSecurityRaw, {
        deep: true
      }) : undefined;
      const queryResourceDataRaw = (_request$query$resour = (_request$query3 = request.query) === null || _request$query3 === void 0 ? void 0 : _request$query3.resource_data) !== null && _request$query$resour !== void 0 ? _request$query$resour : undefined;
      const queryResourceData = queryResourceDataRaw ? (0, _camelcaseKeys.default)(queryResourceDataRaw, {
        deep: true
      }) : undefined;
      const solutionType = (_this$config$onboardi = this.config.onboarding) === null || _this$config$onboardi === void 0 ? void 0 : _this$config$onboardi.default_solution;
      if (queryOnboardingToken || queryOnboardingSecurity || queryResourceData) {
        core.getStartServices().then(async ([coreStart]) => {
          const soClient = coreStart.savedObjects.getScopedClient(request, {
            includedHiddenTypes: [_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE]
          });
          await (0, _cloud_data.persistTokenCloudData)(soClient, {
            logger: this.logger,
            onboardingToken: queryOnboardingToken,
            solutionType,
            security: queryOnboardingSecurity,
            resourceData: queryResourceData
          });
        }).catch(errorMsg => this.logger.error(errorMsg));
      }
      // preserving of the hash is important for the navigation to work correctly with default route
      return response.redirected({
        headers: {
          location: `${basePath}${normalizedRoute.pathname}${normalizedRoute.search}${normalizedRoute.hash}`
        }
      });
    });
    let decodedId;
    if (this.config.id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(this.config.id, this.logger);
    }
    const router = core.http.createRouter();
    const elasticsearchUrl = core.elasticsearch.publicBaseUrl || ((_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.elasticsearchUrl);
    (0, _routes.defineRoutes)({
      logger: this.logger,
      router,
      elasticsearchUrl
    });
    (0, _saved_objects.setupSavedObjects)(core.savedObjects, this.logger);
    return {
      ...this.getCloudUrls(),
      cloudId: this.config.id,
      csp: this.config.csp,
      organizationId,
      instanceSizeMb: (0, _env.readInstanceSizeMb)(),
      deploymentId,
      elasticsearchUrl,
      kibanaUrl: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.kibanaUrl,
      cloudHost: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.host,
      cloudDefaultPort: (_decodedId4 = decodedId) === null || _decodedId4 === void 0 ? void 0 : _decodedId4.defaultPort,
      isCloudEnabled,
      trialEndDate: this.trialEndDate,
      isElasticStaffOwned: this.config.is_elastic_staff_owned,
      apm: {
        url: (_this$config$apm = this.config.apm) === null || _this$config$apm === void 0 ? void 0 : _this$config$apm.url,
        secretToken: (_this$config$apm2 = this.config.apm) === null || _this$config$apm2 === void 0 ? void 0 : _this$config$apm2.secret_token
      },
      onboarding: {
        defaultSolution: (0, _parse_onboarding_default_solution.parseOnboardingSolution)((_this$config$onboardi2 = this.config.onboarding) === null || _this$config$onboardi2 === void 0 ? void 0 : _this$config$onboardi2.default_solution)
      },
      isServerlessEnabled,
      serverless: {
        projectId,
        projectName: (_this$config$serverle6 = this.config.serverless) === null || _this$config$serverle6 === void 0 ? void 0 : _this$config$serverle6.project_name,
        projectType,
        orchestratorTarget,
        // Hi fellow developer! Please, refrain from using `productTier` from this contract.
        // It is exposed for informational purposes (telemetry and feature flags). Do not use it for feature-gating.
        // Use `core.pricing` when checking if a feature is available for the current product tier.
        productTier,
        organizationInTrial: (_this$config$serverle7 = this.config.serverless) === null || _this$config$serverle7 === void 0 ? void 0 : _this$config$serverle7.in_trial
      },
      isInTrial: this.isInTrial.bind(this)
    };
  }
  start() {
    return {
      ...this.getCloudUrls(),
      isCloudEnabled: (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id),
      isInTrial: this.isInTrial.bind(this)
    };
  }
  getCloudUrls() {
    const {
      base_url: baseUrl
    } = this.config;
    const projectsUrl = (0, _utils.getFullCloudUrl)(baseUrl, this.config.projects_url);
    return {
      baseUrl,
      projectsUrl
    };
  }
  isInTrial() {
    var _this$config$serverle8;
    if ((_this$config$serverle8 = this.config.serverless) !== null && _this$config$serverle8 !== void 0 && _this$config$serverle8.in_trial) return true;
    if (this.trialEndDate !== undefined) {
      if (this.config.trial_end_date) {
        const endDateMs = this.trialEndDate.getTime();
        if (!Number.isNaN(endDateMs)) {
          return Date.now() <= endDateMs;
        } else {
          this.logger.error('cloud.trial_end_date config value could not be parsed.');
        }
      }
    }
    return false;
  }
}
exports.CloudPlugin = CloudPlugin;