"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValuesGroup = ValuesGroup;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cloud_integrations/cloud_links/public/maybe_add_cloud_links/appearance_selector/values_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ValuesGroup({
  title,
  values,
  onChange,
  selectedValue,
  ariaLabel
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
    "aria-label": ariaLabel,
    "data-test-subj": "appearanceColorMode",
    checkable: {
      legend: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 19
        }
      }, title)
    },
    css: (0, _react2.css)`
          inline-size: 420px; // Allow for 4 items to fit in a row instead of the default 3
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, values.map(({
    id,
    label,
    icon
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    name: id,
    key: id,
    label: label,
    checkable: "single",
    isSelected: selectedValue === id,
    onChange: () => {
      onChange(id);
    },
    "data-test-subj": `colorModeKeyPadItem${id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  })))));
}