/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.cloudDefend_bundle_jsonpfunction=self.cloudDefend_bundle_jsonpfunction||[]).push([[471],{471:(e,t,s)=>{s.r(t),s.d(t,{CloudDefendFleetPolicyReplaceDefineStepExtension:()=>Ve,default:()=>Ve});var n=s(286),o=s.n(n),a=s(319),l=s(787),i=s(864),r=s(8);const c=r.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),u=r.i18n.translate("xpack.cloudDefend.description",{defaultMessage:"Description"}),d=r.i18n.translate("xpack.cloudDefend.enableControl",{defaultMessage:"Enable policy"}),p=r.i18n.translate("xpack.cloudDefend.enableControlHelp",{defaultMessage:"Enables drift prevention, alert, and logging policy shown below."}),m=r.i18n.translate("xpack.cloudDefend.controlGeneralView",{defaultMessage:"General view"}),g=r.i18n.translate("xpack.cloudDefend.controlYamlView",{defaultMessage:"YAML view"});var x=s(770);const f=r.i18n.translate("xpack.cloudDefend.fileSelector",{defaultMessage:"File selector"}),b=r.i18n.translate("xpack.cloudDefend.processSelector",{defaultMessage:"Process selector"}),h=r.i18n.translate("xpack.cloudDefend.networkSelector",{defaultMessage:"Network (coming soon)"}),y=r.i18n.translate("xpack.cloudDefend.fileResponse",{defaultMessage:"File response"}),k=r.i18n.translate("xpack.cloudDefend.processResponse",{defaultMessage:"Process response"}),j=r.i18n.translate("xpack.cloudDefend.networkResponse",{defaultMessage:"Network (coming soon)"}),v=r.i18n.translate("xpack.cloudDefend.conditions",{defaultMessage:"Conditions: "}),E=r.i18n.translate("xpack.cloudDefend.controlDuplicate",{defaultMessage:"Duplicate"}),C=r.i18n.translate("xpack.cloudDefend.controlRemove",{defaultMessage:"Remove"}),I=r.i18n.translate("xpack.cloudDefend.controlSelectors",{defaultMessage:"Selectors"}),M=r.i18n.translate("xpack.cloudDefend.controlSelectorsHelp",{defaultMessage:"Create file or process selectors to match on operations and or conditions of interest."}),F=r.i18n.translate("xpack.cloudDefend.controlResponses",{defaultMessage:"Responses"}),S=r.i18n.translate("xpack.cloudDefend.controlResponsesHelp",{defaultMessage:'Use responses to map one or more selectors to a set of actions. Selectors can also be used to "exclude" events.'}),A=r.i18n.translate("xpack.cloudDefend.controlMatchSelectors",{defaultMessage:"Match selectors"}),D=r.i18n.translate("xpack.cloudDefend.controlExcludeSelectors",{defaultMessage:"Exclude selectors"}),N=r.i18n.translate("xpack.cloudDefend.controlExclude",{defaultMessage:"Exclude"}),T=r.i18n.translate("xpack.cloudDefend.controlResponseActions",{defaultMessage:"Actions"}),w=r.i18n.translate("xpack.cloudDefend.controlResponseActionLog",{defaultMessage:"Log"}),z=r.i18n.translate("xpack.cloudDefend.controlResponseActionAlert",{defaultMessage:"Alert"}),R=r.i18n.translate("xpack.cloudDefend.controlResponseActionBlock",{defaultMessage:"Block"}),O=r.i18n.translate("xpack.cloudDefend.controlResponseActionBlockHelp",{defaultMessage:"Alert action must be enabled to block an event."}),P=(r.i18n.translate("xpack.cloudDefend.controlResponseActionAlertAndBlock",{defaultMessage:"Alert and block"}),r.i18n.translate("xpack.cloudDefend.addResponse",{defaultMessage:"Add response"})),q=r.i18n.translate("xpack.cloudDefend.addSelector",{defaultMessage:"Add selector"}),$=r.i18n.translate("xpack.cloudDefend.addSelectorCondition",{defaultMessage:"Add condition"}),V=r.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),B=r.i18n.translate("xpack.cloudDefend.unusedSelector",{defaultMessage:"Not in use"}),_=r.i18n.translate("xpack.cloudDefend.unusedSelectorHelp",{defaultMessage:"This selector is not in use by any response."}),L=r.i18n.translate("xpack.cloudDefend.errorInvalidTargetFilePath",{defaultMessage:'"Target file path" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /etc/**'}),W=r.i18n.translate("xpack.cloudDefend.errorInvalidProcessExecutable",{defaultMessage:'"Process executable" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /usr/bin/**'}),J=r.i18n.translate("xpack.cloudDefend.errorInvalidPodLabel",{defaultMessage:'Kubernetes pod label values must have the format: "key:value". A wildcard "*" can be used at the end of the value. e.g. "key:val*". To match on an empty label value, use "key:".'}),G=r.i18n.translate("xpack.cloudDefend.errorInvalidFullContainerImageName",{defaultMessage:'"Full container image name" values must be in the format: image_repo/image_name e.g. "docker.io/nginx"'}),H=r.i18n.translate("xpack.cloudDefend.errorConditionRequired",{defaultMessage:"At least one condition per selector is required."}),Z=r.i18n.translate("xpack.cloudDefend.errorDuplicateName",{defaultMessage:"This name is already used by another selector."}),U=r.i18n.translate("xpack.cloudDefend.errorInvalidName",{defaultMessage:"Selector names must be alphanumeric and contain no spaces."}),Y=r.i18n.translate("xpack.cloudDefend.errorValueRequired",{defaultMessage:"At least one value is required."}),K=r.i18n.translate("xpack.cloudDefend.errorActionRequired",{defaultMessage:"At least one action is required."}),Q=r.i18n.translate("xpack.cloudDefend.errorBlockActionRequiresTargetFilePath",{defaultMessage:'The "block" action requires targetFilePath be included in all "match" selectors using FIM operations or in at least one "exclude" selector. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile'}),X=r.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarTitle",{defaultMessage:"Warning: Blocking FIM operations"}),ee=r.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarText",{defaultMessage:"It is dangerous to block FIM operations using a targetFilePath of /**. This can lead to system instability. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile"}),te={containerImageFullName:{type:"stringArray",pattern:"^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9-](?:\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$",patternError:G,not:["containerImageName"]},containerImageName:{type:"stringArray",pattern:"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$",not:["containerImageFullName"]},containerImageTag:{type:"stringArray"},kubernetesClusterId:{type:"stringArray"},kubernetesClusterName:{type:"stringArray"},kubernetesNamespace:{type:"stringArray"},kubernetesPodName:{type:"stringArray"},kubernetesPodLabel:{type:"stringArray",pattern:"^([a-zA-Z0-9\\.\\-]+\\/)?[a-zA-Z0-9\\.\\-]+:[a-zA-Z0-9\\.\\-\\_]*\\*?$",patternError:J},operation:{type:"stringArray",values:{file:["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"],process:["fork","exec"]}},targetFilePath:{selectorType:"file",type:"stringArray",maxValueBytes:255,pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:L},ignoreVolumeFiles:{selectorType:"file",type:"flag",not:["ignoreVolumeMounts"]},ignoreVolumeMounts:{selectorType:"file",type:"flag",not:["ignoreVolumeFiles"]},processExecutable:{selectorType:"process",type:"stringArray",not:["processName"],pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:W},processName:{selectorType:"process",type:"stringArray",not:["processExecutable"],maxValueBytes:15},sessionLeaderInteractive:{selectorType:"process",type:"boolean"}},se={type:"file",name:"Untitled",operation:["createExecutable","modifyExecutable"]},ne={type:"process",name:"Untitled",operation:["fork","exec"]},oe={type:"file",match:[],actions:["alert"]},ae={type:"process",match:[],actions:["alert"]};var le=s(267);function ie(e){return"process"===e?"gear":"document"}function re(e){const t=e.replace(/([A-Z])/g," $1").toLowerCase();return t[0].toUpperCase()+t.slice(1)}function ce(e,t){const s={process:0,file:0};return e.forEach((e=>{s[e.type]++})),t.forEach((e=>{s[e.type]++})),s}function ue(e){return e&&(!e.operation||0===e.operation.length||e.operation.some((e=>le.U_.indexOf(e)>=0)))}function de(e,t,s,n){return!(!s||!s.reduce(((s,o)=>{const a=e.find((e=>e.name===o)),l=!ue(a)||!(!a||!t.reduce(((e,t)=>e&&Object.hasOwn(a,t)),!0));return n?s&&l:s||l}),n))}function pe(e,t){const s=[];return t.forEach((t=>{var n;if(null!==(n=t.actions)&&void 0!==n&&n.includes("block")){const n=de(e,["targetFilePath"],t.exclude);de(e,["targetFilePath"],t.match,!0)||n||s.push(Q)}})),s}function me(e,t){const s=[],n=te[e].maxValueBytes||le.SD,{pattern:o,patternError:a}=te[e];return null==t||t.forEach((t=>{0===(null==t?void 0:t.length)?s.push(r.i18n.translate("xpack.cloudDefend.errorGenericEmptyValue",{defaultMessage:'"{condition}" values cannot be empty',values:{condition:e}})):o&&!new RegExp(o).test(t)&&(a?s.push(a):s.push(r.i18n.translate("xpack.cloudDefend.errorGenericRegexFailure",{defaultMessage:'"{condition}" values must match the pattern: /{pattern}/',values:{condition:e,pattern:o}}))),new Blob([t]).size>n&&s.push(r.i18n.translate("xpack.cloudDefend.errorMaxValueBytesExceeded",{defaultMessage:'"{condition}" values cannot exceed {maxValueBytes} bytes',values:{condition:e,maxValueBytes:n}}))})),(0,x.uniq)(s)}const ge=()=>{const{euiTheme:e}=(0,a.useEuiTheme)(),{size:t,border:s}=e;return(0,n.useMemo)((()=>({accordion:{borderRadius:s.radius.medium,border:s.thin,"> .euiAccordion__triggerWrapper":{padding:t.m}},conditionsBadge:{display:"inline"},verticalDivider:{display:"inline-block",verticalAlign:"middle",width:"1px",height:"20px",border:s.thin,borderRight:0,borderTop:0,borderBottom:0,marginLeft:t.base,marginRight:t.base}})),[s.radius.medium,s.thin,t.base,t.m])};var xe=s(791);const fe=({label:e,prop:t,selector:s,onChangeBooleanCondition:o,onRemoveCondition:l})=>{const i=s[t],r=(0,n.useCallback)((e=>{o(t,e.target.checked)}),[o,t]);return(0,xe.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t},(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiCheckbox,{id:t,label:e,checked:i,onChange:r})),(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>l(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},be=({label:e,prop:t,onRemoveCondition:s})=>(0,xe.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t},(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiText,{size:"s"},(0,xe.jsx)("p",null,(0,xe.jsx)("small",null,(e=>{switch(e){case"ignoreVolumeMounts":return r.i18n.translate("xpack.cloudDefend.ignoreVolumeMountsHelp",{defaultMessage:"Ignore operations on all volume mounts."});case"ignoreVolumeFiles":return r.i18n.translate("xpack.cloudDefend.ignoreVolumeFilesHelp",{defaultMessage:"Ignore operations on file mounts only. e.g mounted files, configMaps, secrets etc..."});default:return""}})(t))))),(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>s(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t})))),he=({label:e,prop:t,selector:s,errorMap:n,onRemoveCondition:o,onAddValueToCondition:l,onChangeStringArrayCondition:i})=>{const r=s[t],c=(null==r?void 0:r.map((e=>({label:e,value:e}))))||[],u=function(e,t){var s;const n=te[t];return Array.isArray(n.values)?n.values:null!=n&&null!==(s=n.values)&&void 0!==s&&s[e]?n.values[e]:void 0}(s.type,t);return(0,xe.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t,isInvalid:!!Object.hasOwn(n,t)},(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiComboBox,{"aria-label":e,fullWidth:!0,onCreateOption:u?void 0:e=>l(t,e),selectedOptions:c,options:u?u.map((e=>({label:e,value:e}))):c,onChange:e=>i(t,e.map((e=>e.value))),isClearable:!0,"data-test-subj":"cloud-defend-selectorcondition-"+t})),(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>o(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},ye=({selector:e,selectors:t,usedByResponse:s,index:l,onRemove:i,onDuplicate:c,onChange:u})=>{const[d,p]=(0,n.useState)(t.length-1===l?"open":"closed"),[m,g]=(0,n.useState)(!1),[x,f]=(0,n.useState)(!1),[b,h]=(0,n.useState)({}),y=ge(),k=(0,n.useCallback)((()=>{g(!m)}),[m]),j=(0,n.useCallback)((()=>{g(!1)}),[]),I=(0,n.useCallback)((()=>{f(!x)}),[x]),M=(0,n.useCallback)((()=>{f(!1)}),[]),F=(0,n.useMemo)((()=>{return t=e.type,Object.keys(te).filter((e=>{const s=te[e];return!s.selectorType||s.selectorType===t}));var t}),[e]),S=(0,n.useMemo)((()=>F.filter((t=>!Object.hasOwn(e,t)))),[F,e]),A=(0,n.useMemo)((()=>Object.keys(e).filter((e=>!["type","hasErrors","name"].includes(e)))),[e]),D=(0,n.useCallback)((()=>{t.length>1&&i(l),j()}),[j,l,i,t.length]),N=(0,n.useCallback)((()=>{c(e),j()}),[j,c,e]),T=(0,n.useCallback)((s=>{const n=[],o=s.currentTarget.value;t.find((e=>e.name===o))&&n.push(Z),le.tz.test(o)||n.push(U),n.length?b.name=n:delete b.name,h({...b});const a={...e};a.name=o,a.hasErrors=Object.keys(b).length>0||0===A.length,u(a,l)}),[b,l,A,u,e,t]),w=(0,n.useCallback)(((t,s)=>{const n={...e,[t]:s},o=[];0===s.length&&o.push(Y);const a=me(t,s);a.length>0&&o.push(...a),o.length?b[t]=o:delete b[t],n.hasErrors=Object.keys(b).length>0||0===A.length,h({...b}),u(n,l)}),[b,l,A,u,e]),z=(0,n.useCallback)(((t,s)=>{const n={...e,[t]:s};u(n,l)}),[l,u,e]),R=(0,n.useCallback)((e=>{const t=te[e].type;"flag"===t||"boolean"===t?z(e,!0):w(e,[]),M()}),[M,z,w]),O=(0,n.useCallback)((t=>{const s={...e};delete s[t],delete b[t],h({...b}),s.hasErrors=Object.keys(b).length>0||1===A.length,u(s,l),M()}),[M,A,b,l,u,e]),P=(0,n.useCallback)(((t,s)=>{const n=s.trim(),o=e[t];o&&-1===o.indexOf(n)&&w(t,[...o,n])}),[w,e]),q=(0,n.useMemo)((()=>{const e=Object.keys(b).reduce(((e,t)=>e.concat(b[t])),[]);return 0===A.length&&e.push(H),e}),[b,A]),L=(0,n.useCallback)((e=>{p(e?"open":"closed")}),[]);return(0,xe.jsx)(a.EuiAccordion,{id:e.name,forceState:d,onToggle:L,"data-test-subj":"cloud-defend-selector",paddingSize:"m",buttonContent:(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiToolTip,{content:(W=e.type,"process"===W?r.i18n.translate("xpack.cloudDefend.processSelectorIconTooltip",{defaultMessage:"A process selector. Matches only on process operations."}):r.i18n.translate("xpack.cloudDefend.fileSelectorIconTooltip",{defaultMessage:"A file selector. Matches only on file operations."}))},(0,xe.jsx)(a.EuiIcon,{color:"primary",type:ie(e.type)}))),(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiText,{size:"s"},(0,xe.jsx)("b",null,e.name)))),css:y.accordion,extraAction:(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"none"},(0,xe.jsx)("div",null,"closed"===d&&(0,xe.jsx)(o().Fragment,null,(0,xe.jsx)(a.EuiText,{css:y.conditionsBadge,size:"xs"},(0,xe.jsx)("b",null,v)),(0,xe.jsx)(a.EuiBadge,{title:A.join(","),color:"hollow","data-test-subj":"cloud-defend-conditions-count"},A.length)),!s&&(0,xe.jsx)(a.EuiBadge,{title:_,color:"warning"},B),(0,xe.jsx)("div",{css:y.verticalDivider})),(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiPopover,{id:e.name,button:(0,xe.jsx)(a.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:k,"aria-label":"Selector options","data-test-subj":"cloud-defend-btnselectorpopover"}),isOpen:m,closePopover:j,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,xe.jsx)(a.EuiContextMenuPanel,{size:"s",items:[(0,xe.jsx)(a.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:N,"data-test-subj":"cloud-defend-btnduplicateselector"},E),(0,xe.jsx)(a.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:t.length<2,onClick:D,"data-test-subj":"cloud-defend-btndeleteselector"},C)]}))))},(0,xe.jsx)(a.EuiForm,{component:"form",error:q,isInvalid:q.length>0},(0,xe.jsx)(a.EuiFormRow,{label:V,fullWidth:!0,isInvalid:!!Object.hasOwn(b,"name")},(0,xe.jsx)(a.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:T,isInvalid:Object.hasOwn(b,"name"),"data-test-subj":"cloud-defend-selectorcondition-name",maxLength:le.cL})),A.map((t=>{const s=re(t),n=te[t].type;return"flag"===n?(0,xe.jsx)(be,{key:t,label:s,prop:t,onRemoveCondition:O}):"boolean"===n?(0,xe.jsx)(fe,{key:t,label:s,selector:e,prop:t,onChangeBooleanCondition:z,onRemoveCondition:O}):(0,xe.jsx)(he,{key:t,label:s,prop:t,selector:e,errorMap:b,onAddValueToCondition:P,onChangeStringArrayCondition:w,onRemoveCondition:O})}))),(0,xe.jsx)(a.EuiSpacer,{size:"m"}),(0,xe.jsx)(a.EuiPopover,{id:"cloudDefendControlAddCondition","data-test-subj":"cloud-defend-addconditionpopover",button:(0,xe.jsx)(a.EuiButtonEmpty,{onClick:I,iconType:"plusInCircle","data-test-subj":"cloud-defend-btnaddselectorcondition"},$),isOpen:x,closePopover:M,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,xe.jsx)(a.EuiContextMenuPanel,{size:"s",items:S.map((e=>{const t=re(e),s=function(e,t){const s=te[t];return!!e.find((e=>{var t;return null==s||null===(t=s.not)||void 0===t?void 0:t.includes(e)}))}(A,e);return(0,xe.jsx)(a.EuiContextMenuItem,{"data-test-subj":`cloud-defend-addmenu-${e}`,key:e,onClick:()=>R(e),disabled:s},t)}))})));var W},ke=/response_\d+_(.*)/,je=({response:e,selectors:t,responses:s,index:l,onRemove:i,onDuplicate:c,onChange:u})=>{var d,p,m,g,x;const{euiTheme:{colors:f}}=(0,a.useEuiTheme)(),[b,h]=(0,n.useState)(!1),y=(()=>{const{euiTheme:e}=(0,a.useEuiTheme)(),{border:t,size:s}=e,o=(0,a.useEuiBackgroundColor)("subdued");return(0,n.useMemo)((()=>({options:{position:"absolute",top:s.m,right:s.m},accordion:{borderRadius:t.radius.medium,"> .euiAccordion__triggerWrapper":{padding:s.m},backgroundColor:o},accordionHeader:{"> *":{display:"inline-block",verticalAlign:"middle"},"> b":{marginRight:s.s}}})),[o,t.radius.medium,s.m,s.s])})(),k=ge(),[j,v]=(0,n.useState)(s.length-1===l?"open":"closed"),I=null===(d=e.actions)||void 0===d?void 0:d.includes("log"),M=null===(p=e.actions)||void 0===p?void 0:p.includes("alert"),F=null===(m=e.actions)||void 0===m?void 0:m.includes("block"),S=(0,n.useMemo)((()=>F&&function(e,t){return!(!t||!t.reduce(((t,s)=>{var n;const o=e.find((e=>e.name===s)),a=ue(o);return t||!(!a||null==o||null===(n=o.targetFilePath)||void 0===n||!n.includes("/**"))}),!1))}(t,e.match)),[F,e.match,t]),P=(0,n.useMemo)((()=>{var s;const n={};if(0===e.match.length&&(n.match=[Y]),0===(null===(s=e.actions)||void 0===s?void 0:s.length)&&(n.actions=[K]),F){const s=pe(t,[e]);s.length>0&&(n.response=s)}return n}),[e,t,F]),q=(0,n.useMemo)((()=>Object.values(P)),[P]),$=(0,n.useCallback)(((e,t)=>{q.length&&(e.hasErrors=!0),u(e,t)}),[q.length,u]);(0,n.useEffect)((()=>{const t=q.length>0;(t&&!e.hasErrors||!t&&e.hasErrors)&&(e.hasErrors=t,u(e,l))}),[q.length,l,u,e]);const V=(0,n.useCallback)((()=>{h(!b)}),[b]),B=(0,n.useCallback)((()=>{h(!1)}),[]),_=(0,n.useCallback)((()=>{i(l),B()}),[B,l,i]),L=(0,n.useCallback)((()=>{c(e),B()}),[B,c,e]),W=(0,n.useCallback)((t=>{e.match=t.map((e=>e.value)),$(e,l)}),[l,$,e]),J=(0,n.useCallback)((t=>{var s;e.exclude=t.map((e=>e.value)),0===(null===(s=e.exclude)||void 0===s?void 0:s.length)&&delete e.exclude,$(e,l)}),[l,$,e]),G=(0,n.useMemo)((()=>t.filter((t=>{var s;return!(t.type!==e.type||e.match.includes(t.name)||null!==(s=e.exclude)&&void 0!==s&&s.includes(t.name))})).map((e=>({label:e.name,value:e.name})))),[e.exclude,e.match,e.type,t]),H=(0,n.useMemo)((()=>e.match.map((e=>({label:e,value:e,color:f.backgroundLightSuccess})))),[e.match,f]),Z=(0,n.useMemo)((()=>e.exclude&&e.exclude.map((e=>({label:e,value:e,color:f.backgroundLightWarning})))),[e.exclude,f]),U=(0,n.useCallback)((()=>{const t={...e};t.exclude=[],$(t,l)}),[l,$,e]),Q=(0,n.useCallback)((t=>{var s,n,o;const a=null===(s=t.currentTarget)||void 0===s||null===(n=s.id)||void 0===n||null===(o=n.match(ke))||void 0===o?void 0:o[1],i=JSON.parse(JSON.stringify(e)),r=i.actions.indexOf(a);if(-1===r)i.actions.push(a);else{if("alert"===a){const e=i.actions.indexOf("block");-1!==e&&i.actions.splice(e,1)}i.actions.splice(r,1)}$(i,l)}),[l,$,e]),te=(0,n.useCallback)((e=>{v(e?"open":"closed")}),[]),{title:se,plusCount:ne,remainingNames:oe}=(0,n.useMemo)((()=>"open"===j?{title:e.match.slice(0,4).join(", "),plusCount:e.match.length-4,remainingNames:e.match.slice(4).join(",")}:{title:e.match.slice(0,2).join(", "),plusCount:e.match.length-2,remainingNames:e.match.slice(2).join(",")}),[j,e.match]);return(0,xe.jsx)(a.EuiAccordion,{id:"response_"+l,forceState:j,onToggle:te,"data-test-subj":`cloud-defend-${e.type}-response`,paddingSize:"m",buttonContent:(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiToolTip,{content:(ae=e.type,"process"===ae?r.i18n.translate("xpack.cloudDefend.processResponseIconTooltip",{defaultMessage:"A process response.\nOnly process selectors can be used to match/exclude."}):r.i18n.translate("xpack.cloudDefend.fileResponseIconTooltip",{defaultMessage:"A file response.\nOnly file selectors can be used to match/exclude."}))},(0,xe.jsx)(a.EuiIcon,{color:"primary",type:ie(e.type)}))),(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiText,{size:"s",css:y.accordionHeader},(0,xe.jsx)("b",null,se),ne>0&&(0,xe.jsx)(a.EuiBadge,{title:oe},"+",ne)))),css:y.accordion,initialIsOpen:0===l,extraAction:(0,xe.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"none",wrap:!1},"closed"===j&&(0,xe.jsx)(a.EuiText,{color:"subdued",css:k.conditionsBadge,size:"xs"},(null==e||null===(g=e.exclude)||void 0===g?void 0:g.length)&&(0,xe.jsx)(o().Fragment,null,(0,xe.jsx)("b",null,N,": "),(0,xe.jsx)(a.EuiBadge,{title:e.exclude.join(","),color:"hollow"},e.exclude.length),(0,xe.jsx)("div",{css:k.verticalDivider})),(0,xe.jsx)("b",null,T,": "),null===(x=e.actions)||void 0===x?void 0:x.map(((t,s)=>{var n;return(0,xe.jsx)("span",{key:t},(0,xe.jsx)("b",{css:(0,xe.css)({color:"block"===t?f.danger:f.ink},"","")},t[0].toUpperCase()+t.slice(1)),s!==((null===(n=e.actions)||void 0===n?void 0:n.length)||0)-1&&", ")})),(0,xe.jsx)("div",{css:k.verticalDivider})),(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiPopover,{button:(0,xe.jsx)(a.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:V,"aria-label":"Response options","data-test-subj":"cloud-defend-btnresponsepopover"}),isOpen:b,closePopover:B,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,xe.jsx)(a.EuiContextMenuPanel,{size:"s",items:[(0,xe.jsx)(a.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:L,"data-test-subj":"cloud-defend-btnduplicateresponse"},E),(0,xe.jsx)(a.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:s.length<2,onClick:_,"data-test-subj":"cloud-defend-btndeleteresponse"},C)]}))))},(0,xe.jsx)(a.EuiForm,{component:"form",fullWidth:!0,error:q,isInvalid:q.length>0},S&&(0,xe.jsx)(a.EuiFormRow,{fullWidth:!0},(0,xe.jsx)(a.EuiCallOut,{color:"warning",title:X},(0,xe.jsx)("p",null,ee))),(0,xe.jsx)(a.EuiFormRow,{label:A,fullWidth:!0,isInvalid:!!P.match},(0,xe.jsx)(a.EuiComboBox,{"aria-label":A,fullWidth:!0,selectedOptions:H,options:G,isClearable:!0,onChange:W,"data-test-subj":"cloud-defend-responsematch"})),e.exclude&&(0,xe.jsx)(a.EuiFormRow,{label:D,fullWidth:!0},(0,xe.jsx)(a.EuiComboBox,{"aria-label":D,fullWidth:!0,selectedOptions:Z,options:G,onChange:J,isClearable:!0,"data-test-subj":"cloud-defend-responseexclude"})),(0,xe.jsx)(a.EuiSpacer,{size:"s"}),!e.exclude&&(0,xe.jsx)(a.EuiButtonEmpty,{iconType:"plusInCircle",onClick:U,size:"xs","data-test-subj":"cloud-defend-btnshowexclude"},D),(0,xe.jsx)(a.EuiSpacer,{size:"m"}),(0,xe.jsx)(a.EuiFormRow,{label:T,fullWidth:!0,isInvalid:!!P.actions},(0,xe.jsx)(a.EuiFlexGroup,{direction:"row",gutterSize:"l"},(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiCheckbox,{id:`response_${l}_log`,"data-test-subj":"cloud-defend-chklogaction",label:w,checked:I,onChange:Q})),(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiCheckbox,{id:`response_${l}_alert`,"data-test-subj":"cloud-defend-chkalertaction",label:z,checked:M,onChange:Q})),(0,xe.jsx)(a.EuiFlexItem,{grow:!1},(0,xe.jsx)(a.EuiToolTip,{content:O},(0,xe.jsx)(a.EuiCheckbox,{id:`response_${l}_block`,"data-test-subj":"cloud-defend-chkblockaction",label:R,checked:F,onChange:Q,disabled:!M})))))));var ae},ve=({type:e,onSelectType:t,selectors:s,responses:o})=>{const l=(0,n.useMemo)((()=>ce(s,o)),[o,s]),[i,r]=(0,n.useState)(!1),c=()=>{r(!1)},u=(0,n.useCallback)((()=>{c(),t("file")}),[t]),d=(0,n.useCallback)((()=>{c(),t("process")}),[t]),p="Selector"===e,m=[(0,xe.jsx)(a.EuiContextMenuItem,{key:`addFile${e}`,icon:"document",onClick:u,disabled:l.file>=le.o2,"data-test-subj":`cloud-defend-btnAddFile${e}`},p?f:y),(0,xe.jsx)(a.EuiContextMenuItem,{key:`addProcess${e}`,icon:"gear",onClick:d,disabled:l.process>=le.o2,"data-test-subj":`cloud-defend-btnAddProcess${e}`},p?b:k),(0,xe.jsx)(a.EuiContextMenuItem,{key:`addNetwork${e}`,icon:"globe",disabled:!0,"data-test-subj":`cloud-defend-btnAddNetwork${e}`},p?h:j)];return(0,xe.jsx)(a.EuiPopover,{id:`btnAdd${e}`,display:"block",button:(0,xe.jsx)(a.EuiButton,{fullWidth:!0,color:"primary",iconType:"plusInCircle",onClick:()=>{r(!i)},"data-test-subj":`cloud-defend-btnAdd${e}`},p?q:P),isOpen:i,closePopover:c,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,xe.jsx)(a.EuiContextMenuPanel,{size:"s",items:m}))},Ee=({policy:e,onChange:t,show:s})=>{var o,r,c;const u=(0,n.useMemo)((()=>({panel:{position:"relative"},draggable:{padding:0,paddingBottom:"12px"},hide:{display:"none"}})),[]),d=(0,i.rc)(e,l.hc),p=(null==d||null===(o=d.vars)||void 0===o||null===(r=o.configuration)||void 0===r?void 0:r.value)||"",{selectors:m,responses:g}=(0,n.useMemo)((()=>(0,i.xN)(p)),[p]),x=(0,n.useCallback)(((s,n)=>{var o;if(null!=d&&null!==(o=d.vars)&&void 0!==o&&o.configuration){const o=!s.find((e=>e.hasErrors))&&!n.find((e=>e.hasErrors));d.vars.configuration.value=(0,i.R0)(s,n),t({isValid:o,updatedPolicy:{...e}})}}),[null==d||null===(c=d.vars)||void 0===c?void 0:c.configuration,t,e]),f=(0,n.useCallback)((e=>{const t=e.search(/\d+$/),s=-1!==t?e.slice(0,t)+(parseInt(e.slice(t),10)+1):e+"1",n=m.find((e=>e.name===s));return n?f(n.name):s}),[m]),b=(0,n.useCallback)((e=>{const t=function(e){return"process"===e?JSON.parse(JSON.stringify(ne)):JSON.parse(JSON.stringify(se))}(e),s=m.find((e=>e.name===t.name));s&&(t.name=f(s.name)),m.push(t),x(m,g)}),[f,x,g,m]),h=(0,n.useCallback)((e=>{const t=function(e){return"process"===e?{...ae}:{...oe}}(e);g.push(t),x(m,g)}),[x,g,m]),y=(0,n.useCallback)((e=>{const t=JSON.parse(JSON.stringify(e));t.name=f(t.name),m.push(t),x(m,g)}),[f,x,g,m]),k=(0,n.useCallback)((e=>{const t=m[e].name,s=[...m];s.splice(e,1);const n=g.map((e=>{const s={...e},n=s.match.indexOf(t);if(-1!==n&&s.match.splice(n,1),s.exclude){const e=s.exclude.indexOf(t);-1!==e&&s.exclude.splice(e,1)}return s}));x(s,n)}),[x,g,m]),j=(0,n.useCallback)((e=>{const t={...e};g.push(t),x(m,g)}),[x,g,m]),v=(0,n.useCallback)((e=>{const t=[...g];t.splice(e,1),x(m,t)}),[x,g,m]),E=(0,n.useCallback)(((e,t)=>{const s=m[t];!1===e.hasErrors&&delete e.hasErrors;const n=JSON.parse(JSON.stringify(m));let o=JSON.parse(JSON.stringify(g));s.name!==e.name&&(o=g.map((t=>{let n=t.match.indexOf(s.name);return-1!==n&&(t.match[n]=e.name),t.exclude&&(n=t.exclude.indexOf(s.name),-1!==n&&(t.exclude[n]=e.name)),t}))),n[t]=JSON.parse(JSON.stringify(e)),x(n,o)}),[x,g,m]),C=(0,n.useCallback)(((e,t)=>{!1===e.hasErrors&&delete e.hasErrors;const s=JSON.parse(JSON.stringify(g));s[t]=JSON.parse(JSON.stringify(e)),x(m,s)}),[x,g,m]);return(0,xe.jsx)(a.EuiFlexGroup,{css:!s&&u.hide,gutterSize:"m",direction:"column","data-test-subj":"cloud-defend-generalview"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiTitle,{size:"xs"},(0,xe.jsx)("h4",null,I)),(0,xe.jsx)(a.EuiText,{color:"subdued",size:"s"},M)),m.map(((e,t)=>{const s=!!g.find((t=>{var s;return t.match.includes(e.name)||(null==t||null===(s=t.exclude)||void 0===s?void 0:s.includes(e.name))}));return(0,xe.jsx)(a.EuiFlexItem,{key:t},(0,xe.jsx)(ye,{key:t,index:t,selector:e,selectors:m,usedByResponse:s,onDuplicate:y,onRemove:k,onChange:E}))})),(0,xe.jsx)(ve,{type:"Selector",onSelectType:b,selectors:m,responses:g}),(0,xe.jsx)(a.EuiSpacer,{size:"m"}),(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiTitle,{size:"xs"},(0,xe.jsx)("h4",null,F)),(0,xe.jsx)(a.EuiText,{size:"s",color:"subdued"},S)),g.map(((e,t)=>(0,xe.jsx)(a.EuiFlexItem,{key:t},(0,xe.jsx)(je,{index:t,response:e,responses:g,selectors:m,onRemove:v,onDuplicate:j,onChange:C})))),(0,xe.jsx)(ve,{type:"Response",onSelectType:h,selectors:m,responses:g}),(0,xe.jsx)(a.EuiSpacer,{size:"m"}))};var Ce=s(424),Ie=s(911);const Me=JSON.parse('{"$id":"https://elastic.co/cloud-defend/policy-schema.json","$schema":"http://json-schema.org/draft-07/schema#","$comment":"policy-version=1.0.0","type":"object","anyOf":[{"required":["file"]},{"required":["process"]}],"additionalProperties":true,"properties":{"version":{"type":"string"},"file":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileResponse"}}}},"process":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processResponse"}}}}},"$defs":{"fileSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["targetFilePath"]},{"required":["ignoreVolumeMounts"]},{"required":["ignoreVolumeFiles"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"targetFilePath":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"ignoreVolumeMounts":{"type":"boolean","description":"Ignore all volume mounts. e.g directories, files, configMaps, secrets etc...\\nNote: should not be used with ignoreVolumeFiles"},"ignoreVolumeFiles":{"type":"boolean","description":"Ignore file mounts. e.g files, configMaps, secrets\\nNote: should not be used with ignoreVolumeMounts"}},"dependencies":{"ignoreVolumeMounts":{"not":{"required":["ignoreVolumeFiles"]}},"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"processSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["processExecutable"]},{"required":["processName"]},{"required":["sessionLeaderInteractive"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["fork","exec"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^[a-z0-9]+(?:[._-][a-z0-9]+)*$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"processExecutable":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"processName":{"type":"array","minItems":1,"items":{"type":"string"}},"sessionLeaderInteractive":{"type":"boolean"}},"dependencies":{"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"fileResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}},"processResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}}}}'),{Uri:Fe,editor:Se}=Ie.monaco,Ae="http://elastic.co/cloud_defend.json",De=Fe.parse(Ae),Ne=r.i18n.translate("xpack.cloudDefend.alertActionRequired",{defaultMessage:'The alert action is required when "block" action used.'}),Te=r.i18n.translate("xpack.cloudDefend.controlYamlHelp",{defaultMessage:'Configure your policy by creating "file" or "process" selectors and responses below.'}),we=r.i18n.translate("xpack.cloudDefend.controlYamlLoading",{defaultMessage:"Loading editor...."}),{editor:ze}=Ie.monaco,Re=({policy:e,onChange:t,show:s})=>{var o,c;const u=(()=>{const{euiTheme:e}=(0,a.useEuiTheme)(),{border:t}=e;return(0,n.useMemo)((()=>({yamlEditor:{height:"500px",border:t.thin},hide:{visibility:"hidden",position:"absolute"}})),[t.thin])})(),[d,p]=(0,n.useState)([]),[m,g]=(0,n.useState)([]),f=(0,i.rc)(e,l.hc),b=(null==f||null===(o=f.vars)||void 0===o||null===(c=o.configuration)||void 0===c?void 0:c.value)||"",h=(e=>{const[t,s]=(0,n.useState)(null),o=(0,n.useMemo)((()=>{const t={...Me},{selectors:s}=(0,i.xN)(e);if(t.$defs.fileResponse.properties.match.items){const e=t.$defs.fileResponse.properties,n={enum:s.filter((e=>"file"===e.type)).map((e=>e.name))};e.match.items=n,e.exclude.items=n}if(t.$defs.processResponse.properties.match.items){const e=t.$defs.processResponse.properties,n={enum:s.filter((e=>"process"===e.type)).map((e=>e.name))};e.match.items=n,e.exclude.items=n}return t}),[e]);return(0,n.useEffect)((()=>{!async function(...e){const{dispose:t}=await(0,Ie.configureMonacoYamlSchema)(...e);let n=Se.getModel(De);null===n&&(n=Se.createModel("",Ie.YAML_LANG_ID,De)),s(n)}([{uri:Ae,fileMatch:[String(De)],schema:o}])}),[o]),t})(b);(0,n.useEffect)((()=>{h&&h.getValue()!==b&&h.setValue(b)}),[h,b]);const y=(0,n.useCallback)((e=>{const t=[],{selectors:s,responses:n}=(0,i.xN)(e);return t.push(...function(e,t){const s=[],n=ce(e,t);return Object.values(n).forEach((e=>{e>le.o2&&s.push(r.i18n.translate("xpack.cloudDefend.errorMaxSelectorsResponsesExceeded",{defaultMessage:"You cannot exceed {max} selectors + responses for a given type e.g file, process",values:{max:le.o2}}))})),s}(s,n)),t.push(...pe(s,n)),s.forEach((e=>{Object.keys(e).map((s=>{var n;const o=s;if("stringArray"===(null===(n=te[o])||void 0===n?void 0:n.type)){const s=e[o];t.push(...me(o,s))}}))})),n.forEach((e=>{e.actions&&e.actions.includes("block")&&!e.actions.includes("alert")&&t.push(Ne)})),(0,x.uniq)(t)}),[]);(0,n.useEffect)((()=>{if(!s)return;const n=y(b);n.length!==m.length&&g(n);const o=ze.onDidChangeMarkers((([s])=>{const o=ze.getModelMarkers({resource:s}).map((e=>({line:e.startLineNumber,message:e.message})));n.length===m.length&&JSON.stringify(o)===JSON.stringify(d)||(t({isValid:0===n.length&&0===o.length,updatedPolicy:e}),p(o))}));return()=>{o.dispose()}}),[d,t,e,m.length,y,b,s]);const k=(0,n.useCallback)((n=>{if(s&&null!=f&&f.vars){f.vars.configuration.value=n;const s=y(n);g(s),t({isValid:0===s.length&&0===d.length,updatedPolicy:e})}}),[d.length,null==f?void 0:f.vars,t,e,s,y]);return h?(0,xe.jsx)(a.EuiFlexGroup,{direction:"column",css:!s&&u.hide},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiText,{color:"subdued",size:"s"},Te),(0,xe.jsx)(a.EuiSpacer,{size:"s"}),m.length>0&&(0,xe.jsx)(a.EuiForm,{"data-test-subj":"cloudDefendAdditionalErrors",isInvalid:!0,error:m}),(0,xe.jsx)("div",{css:u.yamlEditor},(0,xe.jsx)(Ce.CodeEditor,{width:"100%",languageId:Ce.YAML_LANG_ID,options:{wordWrap:"off",model:h,automaticLayout:!0,padding:{top:10,bottom:10}},onChange:k,value:b})),(0,xe.jsx)(a.EuiSpacer,{size:"s"}))):(0,xe.jsx)(a.EuiFlexGroup,{direction:"column",css:!s&&u.hide},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiText,{color:"subdued",size:"s"},we)))},Oe="general",Pe="yaml",qe=({policy:e,onChange:t})=>{const[s,o]=(0,n.useState)(Oe),[l,i]=(0,n.useState)(!0),r=(0,n.useCallback)((()=>{o(Oe)}),[]),c=(0,n.useCallback)((()=>{o(Pe)}),[]),u=s===Oe,d=s===Pe,p=(0,n.useCallback)((s=>{s.updatedPolicy=e,t(s),i(s.isValid)}),[t,e]),x=(0,n.useCallback)((s=>{s.updatedPolicy=e,t(s),i(s.isValid)}),[t,e]);return(0,xe.jsx)(a.EuiFlexGroup,{direction:"column"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiTabs,null,(0,xe.jsx)(a.EuiTab,{id:Oe,onClick:r,isSelected:u,"data-test-subj":"cloud-defend-btngeneralview",disabled:!l},m),(0,xe.jsx)(a.EuiTab,{id:Pe,onClick:c,isSelected:d,"data-test-subj":"cloud-defend-btnyamlview",disabled:!l},g))),(0,xe.jsx)(a.EuiFlexItem,null,u&&(0,xe.jsx)(Ee,{show:u,policy:e,onChange:p}),(0,xe.jsx)(Re,{show:d,policy:e,onChange:x})))},$e=({policy:e,onChange:t})=>{const[s,o]=(0,n.useState)(!1),r=(0,i.rc)(e,l.hc),m=!(null==r||!r.enabled),g=(0,n.useCallback)((n=>{r&&(r.enabled=n.target.checked,t({isValid:!s,updatedPolicy:{...e}}))}),[r,t,s,e]),x=(0,n.useCallback)((n=>{const o=n.currentTarget.value;t({isValid:!s,updatedPolicy:{...e,name:o}})}),[t,s,e]),f=(0,n.useCallback)((n=>{const o=n.currentTarget.value;t({isValid:!s,updatedPolicy:{...e,description:o}})}),[t,s,e]),b=(0,n.useCallback)((e=>{o(!e.isValid),t(e)}),[t]);return(0,xe.jsx)(a.EuiFlexGroup,{direction:"column"},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiForm,{component:"form"},(0,xe.jsx)(a.EuiFormRow,{label:c,fullWidth:!0},(0,xe.jsx)(a.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:x,"data-test-subj":"cloud-defend-policy-name"})),(0,xe.jsx)(a.EuiFormRow,{label:u,fullWidth:!0},(0,xe.jsx)(a.EuiTextArea,{fullWidth:!0,name:"name",value:e.description,onChange:f,"data-test-subj":"cloud-defend-policy-description",compressed:!0})),(0,xe.jsx)(a.EuiHorizontalRule,null),(0,xe.jsx)(a.EuiFormRow,{fullWidth:!0},(0,xe.jsx)(a.EuiFlexItem,null,(0,xe.jsx)(a.EuiSwitch,{"data-test-subj":"cloud-defend-controltoggle",label:d,checked:m,onChange:g}),(0,xe.jsx)(a.EuiSpacer,{size:"s"}),(0,xe.jsx)(a.EuiText,{color:"subdued",size:"s"},p))))),m&&(0,xe.jsx)(qe,{"data-test-subj":"cloud-defend-controlsettings",policy:e,onChange:b}))},Ve=(0,n.memo)((({newPolicy:e,onChange:t})=>{const s=JSON.parse(JSON.stringify(e));return(0,xe.jsx)($e,{policy:s,onChange:t})}));Ve.displayName="CloudDefendFleetPolicyReplaceDefineStepExtension"}}]);