"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudDefendIntegrationLinks = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../common/constants");
var _use_cloud_defend_integration = require("../api/use_cloud_defend_integration");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloudDefendIntegrationLinks = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const cloudDefendIntegration = (0, _use_cloud_defend_integration.useCloudDefendIntegration)();
  if (!cloudDefendIntegration.isSuccess) return {
    addIntegrationLink: undefined,
    docsLink: 'https://www.elastic.co/guide/index.html'
  };
  const addIntegrationLink = _public.pagePathGetters.add_integration_to_policy({
    integration: _constants.INTEGRATION_PACKAGE_NAME,
    pkgkey: (0, _public.pkgKeyFromPackageInfo)({
      name: cloudDefendIntegration.data.item.name,
      version: cloudDefendIntegration.data.item.version
    })
  }).join('');
  const docsLink = _public.pagePathGetters.integration_details_overview({
    integration: _constants.INTEGRATION_PACKAGE_NAME,
    pkgkey: (0, _public.pkgKeyFromPackageInfo)({
      name: cloudDefendIntegration.data.item.name,
      version: cloudDefendIntegration.data.item.version
    })
  }).join('');
  return {
    addIntegrationLink: http.basePath.prepend(addIntegrationLink),
    docsLink: http.basePath.prepend(docsLink)
  };
};
exports.useCloudDefendIntegrationLinks = useCloudDefendIntegrationLinks;