"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractVisualizationType = exports.extractContainerType = void 0;
exports.getOverridesFor = getOverridesFor;
exports.isOnAggBasedEditor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};

/* Function to identify if the pie is rendered inside the aggBased editor
 Context comes with this format
  {
   type: 'dashboard', // application for lens, agg based charts
   description: 'test',
   child: {
     type: 'lens', // agg_based for legacy editor
     name: 'pie',
     id: 'id',
     description: 'test',
     url: '',
   },
 }; */
exports.extractContainerType = extractContainerType;
const isOnAggBasedEditor = context => {
  if (context) {
    return Boolean(context.type && context.type === 'application' && context.child && context.child.type === 'agg_based');
  }
  return false;
};
exports.isOnAggBasedEditor = isOnAggBasedEditor;
const extractVisualizationType = context => {
  if (context) {
    var _recursiveGet2;
    const recursiveGet = item => {
      if (item.child) {
        return recursiveGet(item.child);
      } else {
        return item;
      }
    };
    return (_recursiveGet2 = recursiveGet(context)) === null || _recursiveGet2 === void 0 ? void 0 : _recursiveGet2.type;
  }
};

/**
 * Get an override specification and returns a props object to use directly with the Component
 * @param overrides Overrides object
 * @param componentName name of the Component to look for (i.e. "settings", "axisX")
 * @returns an props object to use directly with the component
 */
exports.extractVisualizationType = extractVisualizationType;
function getOverridesFor(overrides, componentName) {
  if (!overrides || !overrides[componentName]) {
    return {};
  }
  return Object.fromEntries(Object.entries(overrides[componentName]).map(([key, value]) => {
    if (value === 'ignore') {
      return [key, undefined];
    }
    return [key, value];
  }));
}