"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortOptions = exports.SortActivity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions_activity_bar/sort_activity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortOptions = exports.sortOptions = [{
  value: 'desc',
  text: i18n.NEWEST
}, {
  value: 'asc',
  text: i18n.OLDEST
}];
const SortActivity = exports.SortActivity = /*#__PURE__*/_react.default.memo(({
  sortOrder,
  onOrderChange,
  isLoading = false
}) => {
  const onChange = (0, _react.useCallback)(e => {
    onOrderChange(e.target.value);
  }, [onOrderChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    prepend: i18n.SORT_BY,
    "data-test-subj": "user-actions-sort-select",
    isLoading: isLoading,
    onChange: onChange,
    options: sortOptions,
    value: sortOrder,
    "aria-label": i18n.SORTED_BY_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  });
});
SortActivity.displayName = 'SortActivity';