"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserCommentPropertyActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../client/attachment_framework/types");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _use_lens_open_visualization = require("../../markdown_editor/plugins/lens/use_lens_open_visualization");
var i18n = _interopRequireWildcard(require("./translations"));
var _property_actions = require("./property_actions");
var _delete_attachment_confirmation_modal = require("../delete_attachment_confirmation_modal");
var _use_delete_property_action = require("./use_delete_property_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/property_actions/user_comment_property_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserCommentPropertyActionsComponent = ({
  isLoading,
  commentContent,
  onEdit,
  onDelete,
  onQuote
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete
  });
  const buttonRef = _react.default.useRef(null);
  const {
    canUseEditor,
    actionConfig
  } = (0, _use_lens_open_visualization.useLensOpenVisualization)({
    comment: commentContent !== null && commentContent !== void 0 ? commentContent : ''
  });
  const propertyActions = (0, _react.useMemo)(() => {
    const showEditPencilIcon = permissions.update;
    const showTrashIcon = permissions.delete;
    const showQuoteIcon = permissions.create;
    const showLensEditor = permissions.update && canUseEditor && actionConfig;
    return [...(showEditPencilIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'pencil',
      label: i18n.EDIT_COMMENT,
      onClick: onEdit
    }] : []), ...(showQuoteIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'quote',
      label: i18n.QUOTE,
      onClick: onQuote
    }] : []), ...(showTrashIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'trash',
      color: 'danger',
      label: i18n.DELETE_COMMENT,
      onClick: onModalOpen
    }] : []), ...(showLensEditor ? [actionConfig] : [])];
  }, [permissions.update, permissions.delete, permissions.create, canUseEditor, actionConfig, onEdit, onModalOpen, onQuote]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_property_actions.UserActionPropertyActions, {
    isLoading: isLoading,
    propertyActions: propertyActions,
    buttonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), showDeletionModal ? /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_COMMENT_TITLE,
    confirmButtonText: i18n.DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }) : null);
};
UserCommentPropertyActionsComponent.displayName = 'UserCommentPropertyActions';
const UserCommentPropertyActions = exports.UserCommentPropertyActions = /*#__PURE__*/_react.default.memo(UserCommentPropertyActionsComponent);