"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsDropdown = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../common/lib/kibana");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/configure_cases/connectors_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const suspendedComponentWithProps = ComponentToSuspend => {
  // eslint-disable-next-line react/display-name
  return props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ComponentToSuspend, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  })));
};
const ICON_SIZE = 'm';
const noConnectorOption = {
  value: 'none',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: (0, _react2.css)`
            margin-right: 13px;
            margin-bottom: 0 !important;
          `,
    type: "minusInCircle",
    size: ICON_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `dropdown-connector-no-connector-label`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, i18n.NO_CONNECTOR))),
  'data-test-subj': 'dropdown-connector-no-connector'
};
const ConnectorsDropdownComponent = ({
  connectors,
  disabled,
  isLoading,
  onChange,
  selectedConnector,
  ...props
}) => {
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const connectorsAsOptions = (0, _react.useMemo)(() => {
    const connectorsFormatted = connectors.reduce((acc, connector) => {
      const iconClass = (0, _utils.getConnectorIcon)(triggersActionsUi, connector.actionTypeId);
      return [...acc, {
        value: connector.id,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          responsive: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          css: (0, _react2.css)`
                      margin-right: ${euiTheme.size.m};
                      margin-bottom: 0 !important;
                    `,
          type: typeof iconClass === 'string' ? iconClass : suspendedComponentWithProps(iconClass),
          size: ICON_SIZE,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 19
          }
        }, connector.name, (0, _utils.isDeprecatedConnector)(connector) && ` (${i18n.DEPRECATED_TOOLTIP_TEXT})`)), (0, _utils.isDeprecatedConnector)(connector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          css: (0, _react2.css)`
                        margin-left: ${euiTheme.size.s};
                        margin-bottom: 0 !important;
                      `,
          "aria-label": i18n.DEPRECATED_TOOLTIP_CONTENT,
          size: ICON_SIZE,
          type: "warning",
          color: "warning",
          content: i18n.DEPRECATED_TOOLTIP_CONTENT,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 21
          }
        }))),
        'data-test-subj': `dropdown-connector-${connector.id}`
      }];
    }, [noConnectorOption]);
    return connectorsFormatted;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
    "aria-label": i18n.CONNECTOR_DROPDOWN_LABEL,
    "data-test-subj": "dropdown-connectors",
    disabled: disabled,
    fullWidth: true,
    isLoading: isLoading,
    onChange: onChange,
    options: connectorsAsOptions,
    valueOfSelected: selectedConnector
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }));
};
ConnectorsDropdownComponent.displayName = 'ConnectorsDropdown';
const ConnectorsDropdown = exports.ConnectorsDropdown = /*#__PURE__*/_react.default.memo(ConnectorsDropdownComponent);