"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapePicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _shape_preview = require("../shape_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/shape_picker/shape_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShapePicker = ({
  shapes,
  onChange = () => {}
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  gutterSize: "s",
  columns: 4,
  className: "canvasShapePicker",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
}, shapes.sort().map(shapeKey => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: shapeKey,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  onClick: () => onChange(shapeKey),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_shape_preview.ShapePreview, {
  shape: shapeKey,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 11
  }
})))));
exports.ShapePicker = ShapePicker;
ShapePicker.propTypes = {
  onChange: _propTypes.default.func,
  // @ts-expect-error upgrade typescript v5.9.3
  shapes: _propTypes.default.object.isRequired
};