"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _interpreter = require("@kbn/interpreter");
var _loading = require("../loading");
var _render_with_fn = require("../render_with_fn");
var _element_share_container = require("../element_share_container");
var _invalid_expression = require("./invalid_expression");
var _invalid_element_type = require("./invalid_element_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/element_content/element_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error Untyped local
const ElementContent = props => {
  const {
    renderable,
    renderFunction,
    width,
    height,
    handlers,
    backgroundColor,
    state
  } = props;
  const {
    onComplete
  } = handlers;
  if (!state || !renderable) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      backgroundColor: backgroundColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }

  // renderable is available, but no matching element is found, render invalid
  if (renderable && (0, _interpreter.getType)(renderable) !== 'render' && !renderFunction) {
    return /*#__PURE__*/_react.default.createElement(_invalid_element_type.InvalidElementType, (0, _extends2.default)({}, props, {
      renderableType: renderable === null || renderable === void 0 ? void 0 : renderable.as,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    }));
  }

  // error state, render invalid expression notice
  if (state === 'error' ||
  // The renderable has an error
  (0, _interpreter.getType)(renderable) !== 'render' ||
  // The renderable isn't, well, renderable
  !renderFunction // We can't find an element in the registry for this
  ) {
    return /*#__PURE__*/_react.default.createElement(_invalid_expression.InvalidExpression, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    }));
  }
  const containerStyle = (0, _lodash.omitBy)(renderable.containerStyle, _lodash.isNil);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)(renderable.css)
    // TODO: 'canvas__element' was added for BWC, It can be removed after a while
    ,
    className: (0, _classnames.default)('canvas__element', 'canvasElement', {
      'canvas__element--selected': (props === null || props === void 0 ? void 0 : props.selectedElementId) === props.id
    }),
    style: {
      ...containerStyle,
      width,
      height
    },
    "data-test-subj": "canvasWorkpadPageElementContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_element_share_container.ElementShareContainer, {
    className: "canvasElement__content",
    onComplete: onComplete,
    functionName: renderFunction.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_render_with_fn.RenderWithFn, {
    name: renderFunction.name,
    renderFn: renderFunction.render,
    reuseNode: renderFunction.reuseDomNode,
    config: renderable.value,
    width: width,
    height: height,
    handlers: handlers,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })));
};
exports.ElementContent = ElementContent;