"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Datatable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _paginate = require("../paginate");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/datatable/datatable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getIcon = type => {
  if (type === null) {
    return;
  }
  let icon;
  switch (type) {
    case 'string':
      icon = 'string';
      break;
    case 'number':
      icon = 'number';
      break;
    case 'date':
      icon = 'calendar';
      break;
    case 'boolean':
      icon = 'invert';
      break;
    default:
      icon = 'question';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  });
};
const getColumnName = col => typeof col === 'string' ? col : col.name;
const getColumnId = col => typeof col === 'string' ? col : col.id;
const getColumnType = col => {
  var _col$meta;
  return ((_col$meta = col.meta) === null || _col$meta === void 0 ? void 0 : _col$meta.type) || null;
};
const getFormattedValue = (val, type) => {
  if (type === 'date') {
    return (0, _moment.default)(val).format();
  }
  return String(val);
};
const Datatable = ({
  datatable,
  paginate = false,
  perPage = 10,
  showHeader = false
}) => /*#__PURE__*/_react.default.createElement(_paginate.Paginate, {
  rows: datatable.rows,
  perPage: perPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 3
  }
}, ({
  rows,
  setPage,
  pageNumber,
  totalPages
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable__tableWrapper",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("table", {
  className: "canvasDataTable__table",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 11
  }
}, !showHeader ? null : /*#__PURE__*/_react.default.createElement("thead", {
  className: "canvasDataTable__thead",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement("tr", {
  className: "canvasDataTable__tr",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 17
  }
}, datatable.columns.map(col => /*#__PURE__*/_react.default.createElement("th", {
  key: `header-${getColumnName(col)}`,
  className: "canvasDataTable__th",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 21
  }
}, getColumnName(col), "\xA0", getIcon(getColumnType(col)))))), /*#__PURE__*/_react.default.createElement("tbody", {
  className: "canvasDataTable__tbody",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 13
  }
}, rows.map((row, i) => /*#__PURE__*/_react.default.createElement("tr", {
  key: i,
  className: "canvasDataTable__tr",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 17
  }
}, datatable.columns.map(col => /*#__PURE__*/_react.default.createElement("td", {
  key: `row-${i}-${getColumnName(col)}`,
  className: "canvasDataTable__td",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 21
  }
}, getFormattedValue(row[getColumnId(col)], getColumnType(col))))))))), paginate && /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable__footer",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
  "aria-label": _i18n.i18n.translate('xpack.canvas.canvasDatatable.pagination.ariaLabel', {
    defaultMessage: 'Data table pages'
  }),
  pageCount: totalPages,
  activePage: pageNumber,
  onPageClick: setPage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 13
  }
}))));
exports.Datatable = Datatable;
Datatable.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  datatable: _propTypes.default.object.isRequired,
  paginate: _propTypes.default.bool,
  perPage: _propTypes.default.number,
  showHeader: _propTypes.default.bool
};