"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _color_manager = require("../color_manager");
var _color_palette = require("../color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/color_picker/color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorPicker = ({
  colors = [],
  hasButtons = false,
  onAddColor,
  onChange,
  onRemoveColor,
  value = ''
}) => {
  const isValidColor = _chromaJs.default.valid(value);
  colors = colors.filter(color => {
    return _chromaJs.default.valid(color);
  });
  let canRemove = false;
  let canAdd = false;
  if (isValidColor) {
    const match = colors.filter(color => (0, _chromaJs.default)(value).hex() === (0, _chromaJs.default)(color).hex());
    canRemove = match.length > 0;
    canAdd = match.length === 0;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_color_palette.ColorPalette, {
    onChange: onChange,
    value: value,
    colors: colors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_color_manager.ColorManager, {
    onChange: onChange,
    value: value,
    onAddColor: canAdd ? onAddColor : undefined,
    onRemoveColor: canRemove ? onRemoveColor : undefined,
    hasButtons: hasButtons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.ColorPicker = ColorPicker;
ColorPicker.propTypes = {
  colors: _propTypes.default.array,
  hasButtons: _propTypes.default.bool,
  onAddColor: _propTypes.default.func,
  onChange: _propTypes.default.func.isRequired,
  onRemoveColor: _propTypes.default.func,
  value: _propTypes.default.string
};