"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressComponent = ProgressComponent;
exports.getId = getId;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _shape_drawer = require("../../../../public/components/shape_drawer");
var _progress_drawer = require("./progress_drawer");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/progress/components/progress_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getId(type) {
  return `${type}-${(0, _uuid.v4)()}`;
}
function ProgressComponent({
  onLoaded,
  parentNode,
  shape: shapeType,
  value,
  max,
  valueColor,
  barColor,
  valueWeight,
  barWeight,
  label,
  font
}) {
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: parentNode.offsetWidth,
    height: parentNode.offsetHeight
  });
  const [shapeData, setShapeData] = (0, _react.useState)((0, _shape_drawer.getDefaultShapeData)());
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setShapeData(node.getData());
    }
  }, []);
  const [totalLength, setTotalLength] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    setDimensions({
      width: parentNode.offsetWidth,
      height: parentNode.offsetHeight
    });
    onLoaded();
  }, [onLoaded, parentNode, parentNodeDimensions]);
  const progressRef = (0, _react.useRef)(null);
  const textRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setTotalLength(progressRef.current ? progressRef.current.getTotalLength() : 0);
  }, [shapeType, shapeData, progressRef]);
  const BarProgress = shapeData.shapeType ? (0, _shape_drawer.getShapeContentElement)(shapeData.shapeType) : null;
  const shapeContentAttributes = {
    fill: 'none',
    stroke: barColor,
    strokeWidth: `${barWeight}px`
  };
  const percent = value / max;
  const to = totalLength * (1 - percent);
  const barProgressAttributes = {
    ...shapeData.shapeProps,
    fill: 'none',
    stroke: valueColor,
    strokeWidth: `${valueWeight}px`,
    strokeDasharray: totalLength,
    strokeDashoffset: Math.max(0, to)
  };
  const {
    width: labelWidth,
    height: labelHeight
  } = textRef.current ? textRef.current.getBBox() : {
    width: 0,
    height: 0
  };
  const offset = Math.max(valueWeight, barWeight);
  const updatedTextAttributes = shapeData.textAttributes ? (0, _utils.getTextAttributes)(shapeType, shapeData.textAttributes, offset, label) : {};
  const textAttributes = {
    style: font.spec,
    ...updatedTextAttributes
  };
  const updatedViewBox = (0, _utils.getViewBox)(shapeType, shapeData.viewBox, offset, labelWidth, labelHeight);
  const shapeAttributes = {
    id: getId('svg'),
    ...(dimensions || {}),
    viewBox: updatedViewBox
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "shapeAligner",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_progress_drawer.ProgressDrawerComponent, {
    shapeType: shapeType,
    shapeContentAttributes: {
      ...shapeContentAttributes,
      ref: progressRef
    },
    shapeAttributes: shapeAttributes,
    textAttributes: {
      ...textAttributes,
      ref: textRef
    },
    ref: shapeRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, BarProgress && /*#__PURE__*/_react.default.createElement(BarProgress, (0, _extends2.default)({}, barProgressAttributes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 25
    }
  }))));
}