"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticImportService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _index_service = require("./samples_index/index_service");
var _get_user = require("./lib/get_user");
var _saved_objects_service = require("./saved_objects/saved_objects_service");
var _integration = require("./saved_objects/integration");
var _data_stream = require("./saved_objects/data_stream");
var _task_manager_service = require("./task_manager/task_manager_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutomaticImportService {
  constructor(logger, esClientPromise, savedObjectsServiceSetup, taskManagerSetup) {
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "samplesIndexService", void 0);
    (0, _defineProperty2.default)(this, "security", null);
    (0, _defineProperty2.default)(this, "savedObjectService", null);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsServiceSetup", void 0);
    (0, _defineProperty2.default)(this, "taskManagerSetup", void 0);
    (0, _defineProperty2.default)(this, "taskManagerService", void 0);
    (0, _defineProperty2.default)(this, "processDataStreamWorkflow", async params => {
      // TODO: Implement the actual AI agent workflow here that uses AgentService
      // Will use params.integrationId and params.dataStreamId
    });
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.logger = logger;
    this.savedObjectsServiceSetup = savedObjectsServiceSetup;
    this.samplesIndexService = new _index_service.AutomaticImportSamplesIndexService(logger, esClientPromise);
    this.savedObjectsServiceSetup.registerType(_integration.integrationSavedObjectType);
    this.savedObjectsServiceSetup.registerType(_data_stream.dataStreamSavedObjectType);
    this.taskManagerSetup = taskManagerSetup;
    this.taskManagerService = new _task_manager_service.TaskManagerService(this.logger, this.taskManagerSetup);
  }
  // Run initialize in the start phase of plugin
  async initialize(security, savedObjectsServiceStart, taskManagerStart) {
    this.security = security;
    const savedObjectsClient = savedObjectsServiceStart.createInternalRepository();
    this.savedObjectService = new _saved_objects_service.AutomaticImportSavedObjectService(this.logger, savedObjectsClient, this.security);
    this.taskManagerService.initialize(taskManagerStart, {
      taskWorkflow: this.processDataStreamWorkflow
    });
  }
  async addSamplesToDataStream(dataStream, request) {
    if (!this.security) {
      throw new Error('Security service not initialized.');
    }
    const currentAuthenticatedUser = (0, _get_user.getAuthenticatedUser)(request, this.security);
    await this.samplesIndexService.addSamplesToDataStream(currentAuthenticatedUser, dataStream);
  }
  async insertIntegration(request, data, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.insertIntegration(request, data, options);
  }
  async updateIntegration(data, expectedVersion, versionUpdate, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.updateIntegration(data, expectedVersion, versionUpdate, options);
  }
  async getIntegration(integrationId) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.getIntegration(integrationId);
  }
  async getAllIntegrations() {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.getAllIntegrations();
  }
  async deleteIntegration(integrationId, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.deleteIntegration(integrationId, options);
  }
  async insertDataStream(request, data, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.insertDataStream(request, data, options);
  }
  async updateDataStream(data, expectedVersion, versionUpdate, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.updateDataStream(data, expectedVersion, versionUpdate, options);
  }
  async getDataStream(dataStreamId) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.getDataStream(dataStreamId);
  }
  async getAllDataStreams() {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.getAllDataStreams();
  }
  async findAllDataStreamsByIntegrationId(integrationId) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.findAllDataStreamsByIntegrationId(integrationId);
  }
  async deleteDataStream(dataStreamId, options) {
    if (!this.savedObjectService) {
      throw new Error('Saved Objects service not initialized.');
    }
    return this.savedObjectService.deleteDataStream(dataStreamId, options);
  }
  stop() {
    this.pluginStop$.next();
    this.pluginStop$.complete();
  }
}
exports.AutomaticImportService = AutomaticImportService;