"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticImportV2Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _request_context_factory = require("./request_context_factory");
var _services = require("./services");
var _feature = require("./feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutomaticImportV2Plugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "automaticImportService", null);
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.logger = initializerContext.logger.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }

  /**
   * Setup the plugin
   * @param core
   * @param plugins
   * @returns AutomaticImportPluginSetup
   */
  setup(core, plugins) {
    this.logger.debug('automaticImportV2: Setup');
    plugins.features.registerKibanaFeature(_feature.AUTOMATIC_IMPORT_FEATURE);
    const coreStartServices = core.getStartServices().then(([coreStart]) => ({
      esClient: coreStart.elasticsearch.client.asInternalUser
    }));
    const esClientPromise = coreStartServices.then(({
      esClient
    }) => esClient);
    this.automaticImportService = new _services.AutomaticImportService(this.logger, esClientPromise, core.savedObjects, plugins.taskManager);
    const requestContextFactory = new _request_context_factory.RequestContextFactory({
      logger: this.logger,
      core,
      plugins,
      kibanaVersion: this.kibanaVersion,
      automaticImportService: this.automaticImportService
    });
    core.http.registerRouteHandlerContext('automaticImportv2', (context, request) => requestContextFactory.create(context, request));
    return {
      actions: plugins.actions
    };
  }

  /**
   * Start the plugin
   * @param core
   * @param plugins
   * @returns AutomaticImportPluginStart
   */
  start(core, plugins) {
    this.logger.debug('automaticImportV2: Started');
    if (!plugins.security) {
      throw new Error('Security service not initialized.');
    }
    if (!core.savedObjects) {
      throw new Error('SavedObjects service not initialized.');
    }
    if (!plugins.taskManager) {
      throw new Error('TaskManager service not initialized.');
    }
    if (!this.automaticImportService) {
      throw new Error('AutomaticImportService not initialized during setup');
    }
    this.automaticImportService.initialize(core.security, core.savedObjects, plugins.taskManager).then(() => {
      this.logger.debug('AutomaticImportService initialized successfully');
    }).catch(error => {
      this.logger.error('Failed to initialize AutomaticImportService', error);
    });
    this.logger.info('TaskManagerService initialized successfully');
    return {
      actions: plugins.actions,
      inference: plugins.inference,
      licensing: plugins.licensing,
      security: plugins.security
    };
  }

  /**
   * Stop the plugin
   */
  stop() {
    var _this$automaticImport;
    this.pluginStop$.next();
    this.pluginStop$.complete();
    (_this$automaticImport = this.automaticImportService) === null || _this$automaticImport === void 0 ? void 0 : _this$automaticImport.stop();
  }
}
exports.AutomaticImportV2Plugin = AutomaticImportV2Plugin;