"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Integration = exports.InputType = exports.DataStream = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("./primitive.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Common Attributes Model
 *   version: not applicable
 */

/**
 * The input type object with its settings.
 */

const InputType = exports.InputType = _zod.z.object({
  /**
   * The name of the input type
   */
  name: _zod.z.enum(['aws-cloudwatch', 'aws-s3', 'azure-blob-storage', 'azure-eventhub', 'cloudfoundry', 'filestream', 'gcp-pubsub', 'gcs', 'http_endpoint', 'journald', 'kafka', 'tcp', 'udp'])
});

/**
 * The data stream object with its settings.
 */

const DataStream = exports.DataStream = _zod.z.object({
  /**
   * The title of the data stream
   */
  title: _primitive.NonEmptyString.optional(),
  /**
   * The description of the data stream
   */
  description: _primitive.NonEmptyString.optional(),
  /**
   * The input types of the data stream
   */
  inputTypes: _zod.z.array(InputType).optional(),
  /**
   * The raw samples of the data stream
   */
  rawSamples: _zod.z.array(_zod.z.string()).optional()
});

/**
 * The integration object with its settings.
 */

const Integration = exports.Integration = _zod.z.object({
  /**
   * The integration id
   */
  integration_id: _primitive.NonEmptyString,
  /**
   * The data streams of the integration
   */
  dataStreams: _zod.z.array(DataStream).optional(),
  /**
   * The logo of the integration
   */
  logo: _zod.z.string().optional(),
  /**
   * The description of the integration
   */
  description: _primitive.NonEmptyString.optional(),
  /**
   * The title of the integration
   */
  title: _primitive.NonEmptyString.optional()
}).strict();