"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDataProviders = registerDataProviders;
var _get_random_sampler = require("../lib/helpers/get_random_sampler");
var _get_apm_service_summary = require("../routes/assistant_functions/get_apm_service_summary");
var _get_apm_downstream_dependencies = require("../routes/assistant_functions/get_apm_downstream_dependencies");
var _get_apm_errors = require("../routes/assistant_functions/get_observability_alert_details_context/get_apm_errors");
var _get_changepoints = require("../routes/assistant_functions/get_changepoints");
var _build_apm_tool_resources = require("../agent_tools/utils/build_apm_tool_resources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerDataProviders({
  core,
  plugins,
  logger
}) {
  const {
    observabilityAgent
  } = plugins;
  if (!observabilityAgent) {
    return;
  }
  observabilityAgent.registerDataProvider('apmServiceSummary', async ({
    request,
    serviceName,
    serviceEnvironment,
    start,
    end,
    transactionType
  }) => {
    const {
      apmEventClient,
      apmAlertsClient,
      mlClient,
      esClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    return (0, _get_apm_service_summary.getApmServiceSummary)({
      apmEventClient,
      esClient: esClient.asCurrentUser,
      apmAlertsClient,
      mlClient,
      logger,
      arguments: {
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        start,
        end,
        'transaction.type': transactionType
      }
    });
  });
  observabilityAgent.registerDataProvider('apmDownstreamDependencies', async ({
    request,
    serviceName,
    serviceEnvironment,
    start,
    end
  }) => {
    const {
      apmEventClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    const [coreStart] = await core.getStartServices();
    const randomSampler = await (0, _get_random_sampler.getRandomSampler)({
      coreStart,
      probability: 1,
      request
    });
    return (0, _get_apm_downstream_dependencies.getApmDownstreamDependencies)({
      apmEventClient,
      randomSampler,
      arguments: {
        serviceName,
        serviceEnvironment,
        start,
        end
      }
    });
  });
  observabilityAgent.registerDataProvider('apmErrors', async ({
    request,
    serviceName,
    serviceEnvironment,
    start,
    end
  }) => {
    const {
      apmEventClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    return (0, _get_apm_errors.getApmErrors)({
      apmEventClient,
      serviceName,
      serviceEnvironment,
      start,
      end
    });
  });
  observabilityAgent.registerDataProvider('apmExitSpanChangePoints', async ({
    request,
    serviceName,
    serviceEnvironment,
    start,
    end
  }) => {
    const {
      apmEventClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    return (0, _get_changepoints.getExitSpanChangePoints)({
      apmEventClient,
      serviceName,
      serviceEnvironment,
      start,
      end
    });
  });
  observabilityAgent.registerDataProvider('apmServiceChangePoints', async ({
    request,
    serviceName,
    serviceEnvironment,
    transactionType,
    transactionName,
    start,
    end
  }) => {
    const {
      apmEventClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    return (0, _get_changepoints.getServiceChangePoints)({
      apmEventClient,
      serviceName,
      serviceEnvironment,
      transactionType,
      transactionName,
      start,
      end
    });
  });
}