"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildApmToolResources = buildApmToolResources;
var _rxjs = require("rxjs");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_random_sampler = require("../../lib/helpers/get_random_sampler");
var _get_ml_client = require("../../lib/helpers/get_ml_client");
var _get_apm_alerts_client = require("../../lib/helpers/get_apm_alerts_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function buildApmToolResources({
  core,
  plugins,
  request,
  esClient,
  logger
}) {
  const [coreStart, pluginStart] = await core.getStartServices();
  const esScoped = esClient !== null && esClient !== void 0 ? esClient : coreStart.elasticsearch.client.asScoped(request);
  const soClient = coreStart.savedObjects.getScopedClient(request, {
    includedHiddenTypes: []
  });
  const uiSettingsClient = coreStart.uiSettings.asScopedToClient(soClient);
  const licensingContext = (0, _rxjs.firstValueFrom)(pluginStart.licensing.license$).then(license => ({
    license,
    featureUsage: pluginStart.licensing.featureUsage
  }));
  const contextAdapter = {
    core: Promise.resolve({
      savedObjects: {
        client: soClient
      },
      uiSettings: {
        client: uiSettingsClient
      },
      elasticsearch: {
        client: esScoped
      }
    }),
    licensing: licensingContext
  };
  const pluginsAdapter = {
    ml: plugins.ml ? {
      setup: plugins.ml,
      start: async () => pluginStart.ml
    } : undefined,
    ruleRegistry: {
      setup: plugins.ruleRegistry,
      start: async () => pluginStart.ruleRegistry
    }
  };
  const apmEventClientPromise = (0, _get_apm_event_client.getApmEventClient)({
    context: contextAdapter,
    request,
    params: {
      query: {
        _inspect: false
      }
    },
    getApmIndices: async () => {
      return plugins.apmDataAccess.getApmIndices(soClient);
    }
  });
  const randomSamplerPromise = (0, _get_random_sampler.getRandomSampler)({
    coreStart,
    request,
    probability: 1
  });
  const mlClientPromise = (0, _get_ml_client.getMlClient)({
    plugins: pluginsAdapter,
    context: contextAdapter,
    request
  }).catch(() => undefined);
  const apmAlertsClientPromise = (0, _get_apm_alerts_client.getApmAlertsClient)({
    context: contextAdapter,
    plugins: pluginsAdapter,
    request
  });
  const [apmEventClient, randomSampler, mlClient, apmAlertsClient] = await Promise.all([apmEventClientPromise, randomSamplerPromise, mlClientPromise, apmAlertsClientPromise]);
  return {
    apmEventClient,
    randomSampler,
    mlClient,
    apmAlertsClient,
    esClient: esScoped
  };
}