"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingPlugin = useProfilingPlugin;
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("./use_fetcher");
var _use_profiling_integration_setting = require("./use_profiling_integration_setting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingPlugin() {
  const {
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const isProfilingPluginEnabled = (0, _use_profiling_integration_setting.useProfilingPluginSetting)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/profiling/status');
  }, []);
  const isProfilingAvailable = isProfilingPluginEnabled && (data === null || data === void 0 ? void 0 : data.initialized);
  return {
    profilingLocators: isProfilingAvailable ? plugins.observabilityShared.locators.profiling : undefined,
    isProfilingPluginInitialized: data === null || data === void 0 ? void 0 : data.initialized,
    isProfilingAvailable,
    isLoading: (0, _use_fetcher.isPending)(status)
  };
}