"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveUrlParams = resolveUrlParams;
var _environment_filter_values = require("../../../common/environment_filter_values");
var _latency_aggregation_types = require("../../../common/latency_aggregation_types");
var _url_helpers = require("../../components/shared/links/url_helpers");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function resolveUrlParams(location, state) {
  const query = (0, _url_helpers.toQuery)(location.search);
  const {
    sampleRangeFrom,
    sampleRangeTo,
    traceId,
    transactionId,
    transactionName,
    transactionType,
    detailTab,
    flyoutDetailTab,
    waterfallItemId,
    spanId,
    page,
    pageSize,
    sortDirection,
    sortField,
    kuery,
    refreshPaused,
    refreshInterval,
    rangeFrom,
    rangeTo,
    environment,
    searchTerm,
    percentile,
    latencyAggregationType = _latency_aggregation_types.LatencyAggregationType.avg,
    comparisonEnabled,
    offset,
    logsColumns,
    logsSort,
    logsGrid,
    logsRowHeight,
    logsRowsPerPage,
    logsDensity
  } = query;
  return (0, _helpers.removeUndefinedProps)({
    // date params
    ...(0, _helpers.getDateRange)({
      state,
      rangeFrom,
      rangeTo
    }),
    rangeFrom,
    rangeTo,
    refreshPaused: refreshPaused ? (0, _helpers.toBoolean)(refreshPaused) : undefined,
    refreshInterval: refreshInterval ? (0, _helpers.toNumber)(refreshInterval) : undefined,
    // query params
    environment: (0, _helpers.toString)(environment) || _environment_filter_values.ENVIRONMENT_ALL.value,
    sortDirection,
    sortField,
    page: (0, _helpers.toNumber)(page) || 0,
    pageSize: pageSize ? (0, _helpers.toNumber)(pageSize) : undefined,
    transactionId: (0, _helpers.toString)(transactionId),
    traceId: (0, _helpers.toString)(traceId),
    sampleRangeFrom: sampleRangeFrom ? (0, _helpers.toNumber)(sampleRangeFrom) : undefined,
    sampleRangeTo: sampleRangeTo ? (0, _helpers.toNumber)(sampleRangeTo) : undefined,
    waterfallItemId: (0, _helpers.toString)(waterfallItemId),
    detailTab: (0, _helpers.toString)(detailTab),
    flyoutDetailTab: (0, _helpers.toString)(flyoutDetailTab),
    spanId: (0, _helpers.toNumber)(spanId),
    kuery,
    transactionName,
    transactionType,
    searchTerm: (0, _helpers.toString)(searchTerm),
    percentile: (0, _helpers.toNumber)(percentile),
    latencyAggregationType: latencyAggregationType,
    comparisonEnabled: comparisonEnabled ? (0, _helpers.toBoolean)(comparisonEnabled) : undefined,
    offset,
    // Logs tab state
    logsColumns: (0, _helpers.toString)(logsColumns),
    logsSort: (0, _helpers.toString)(logsSort),
    logsGrid: (0, _helpers.toString)(logsGrid),
    logsRowHeight: logsRowHeight ? (0, _helpers.toNumber)(logsRowHeight) : undefined,
    logsRowsPerPage: logsRowsPerPage ? (0, _helpers.toNumber)(logsRowsPerPage) : undefined,
    logsDensity: (0, _helpers.toString)(logsDensity)
  });
}