"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pushNewItemToKueryBar = pushNewItemToKueryBar;
var _lodash = require("lodash");
var _url_helpers = require("../links/url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function pushNewItemToKueryBar({
  kuery,
  history,
  key,
  value
}) {
  const newItem = `${key} :"${value}"`;
  const nextKuery = (0, _lodash.isEmpty)(kuery) ? newItem : `${kuery} and ${newItem}`;
  (0, _url_helpers.push)(history, {
    query: {
      kuery: nextKuery
    }
  });
}