"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlamegraphChart = FlamegraphChart;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/flamegraph/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FlamegraphChart({
  data,
  status
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status === _use_fetcher.FETCH_STATUS.SUCCESS && ((0, _lodash.isEmpty)(data) || (data === null || data === void 0 ? void 0 : data.TotalSamples) === 0) ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.apm.profiling.flamegraph.noDataFound', {
      defaultMessage: 'No data found'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_public.EmbeddableFlamegraph, {
    data: data,
    isLoading: (0, _use_fetcher.isPending)(status),
    height: "35vh",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }));
}