"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmCustomAssetsExtension = ApmCustomAssetsExtension;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_custom_assets_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmCustomAssetsExtension() {
  const {
    http
  } = (0, _public2.useKibana)().services;
  const basePath = http === null || http === void 0 ? void 0 : http.basePath.get();
  const views = [{
    name: _i18n.i18n.translate('xpack.apm.fleetIntegration.assets.name', {
      defaultMessage: 'Service inventory'
    }),
    url: `${basePath}/app/apm`,
    description: _i18n.i18n.translate('xpack.apm.fleetIntegration.assets.description', {
      defaultMessage: 'View application traces and service maps in APM'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 10
    }
  });
}