"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceLink = TraceLink;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_redirect_to_transaction_detail_page_url = require("./get_redirect_to_transaction_detail_page_url");
var _get_redirect_to_trace_page_url = require("./get_redirect_to_trace_page_url");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/trace_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CentralizedContainer = _styled.default.div`
  height: 100%;
  display: flex;
`;
function TraceLink() {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    data: dataService
  } = services;
  const timeRange = dataService.query.timefilter.timefilter.getTime();
  const {
    path: {
      traceId
    },
    query: {
      rangeFrom = timeRange.from,
      rangeTo = timeRange.to,
      waterfallItemId
    }
  } = (0, _use_apm_params.useApmParams)('/link-to/trace/{traceId}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom: rangeFrom || new Date(0).toISOString(),
    rangeTo: rangeTo || new Date().toISOString()
  });
  const {
    data = {
      transaction: null
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (traceId) {
      return callApmApi('GET /internal/apm/traces/{traceId}/root_transaction', {
        params: {
          path: {
            traceId
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [traceId, start, end]);
  if (traceId && status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    const to = data.transaction ? (0, _get_redirect_to_transaction_detail_page_url.getRedirectToTransactionDetailPageUrl)({
      transaction: data.transaction,
      rangeFrom,
      rangeTo,
      waterfallItemId
    }) : (0, _get_redirect_to_trace_page_url.getRedirectToTracePageUrl)({
      traceId,
      rangeFrom,
      rangeTo
    });
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: to,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "apmTrace",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.traceLink.fetchingTraceLabel', {
      defaultMessage: 'Fetching trace...'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
}