"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCustomLinkButton = CreateCustomLinkButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _custom_link = require("../../../../../common/custom_link");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_custom_link_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CreateCustomLinkButton({
  onClick
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = core.application.capabilities.apm['settings:save'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _custom_link.NO_PERMISSION_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    iconType: "plusInCircle",
    onClick: onClick,
    isDisabled: !canSave,
    "data-test-subj": "createButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.createCustomLink', {
    defaultMessage: 'Create custom link'
  })));
}