"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsList = JobsList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _get_anomaly_detection_setup_state = require("../../../../../common/anomaly_detection/get_anomaly_detection_setup_state");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_ml_manage_jobs_href = require("../../../../hooks/use_ml_manage_jobs_href");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _mlexplorer_link = require("../../../shared/links/machine_learning_links/mlexplorer_link");
var _mlmanage_jobs_link = require("../../../shared/links/machine_learning_links/mlmanage_jobs_link");
var _loading_state_prompt = require("../../../shared/loading_state_prompt");
var _managed_table = require("../../../shared/managed_table");
var _ml_callout = require("../../../shared/ml_callout");
var _jobs_list_status = require("./jobs_list_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/anomaly_detection/jobs_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = [{
  field: 'environment',
  name: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.environmentColumnLabel', {
    defaultMessage: 'Environment'
  }),
  width: '100%',
  render: (_, {
    environment,
    jobId,
    jobState,
    datafeedState,
    version
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, (0, _environment_filter_values.getEnvironmentLabel)(environment)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_jobs_list_status.JobsListStatus, {
      jobId: jobId,
      version: version,
      jobState: jobState,
      datafeedState: datafeedState,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    })));
  }
}, {
  field: 'job_id',
  align: _eui.RIGHT_ALIGNMENT,
  name: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.actionColumnLabel', {
    defaultMessage: 'Action'
  }),
  render: (_, {
    jobId
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.mlJobLinkText', {
        defaultMessage: 'Manage job'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_mlmanage_jobs_link.MLManageJobsLink, {
      jobId: jobId,
      key: jobId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "gear",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.openAnomalyExplorerrLinkText', {
        defaultMessage: 'Open in Anomaly Explorer'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_mlexplorer_link.MLExplorerLink, {
      jobId: jobId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    })))));
  }
}];
function JobsList({
  data,
  status,
  onAddEnvironments,
  setupState,
  onUpdateComplete
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    jobs
  } = data;

  // default to showing legacy jobs if not up to date
  const [showLegacyJobs, setShowLegacyJobs] = (0, _react.useState)(setupState !== _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.UpToDate);
  const mlManageJobsHref = (0, _use_ml_manage_jobs_href.useMlManageJobsHref)();
  const canSave = core.application.capabilities.apm['settings:save'];
  const displayMlCallout = (0, _ml_callout.shouldDisplayMlCallout)(setupState) && canSave;
  const filteredJobs = showLegacyJobs ? jobs : jobs.filter(job => job.version >= 3);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
    jobIds: filteredJobs.map(j => j.jobId),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.settings.anomalyDetection.jobList.mlDescriptionText",
    defaultMessage: "To add anomaly detection to a new environment, create a machine learning job. Existing machine learning jobs can be managed in {mlJobsLink}.",
    values: {
      mlJobsLink: /*#__PURE__*/_react.default.createElement(_mlmanage_jobs_link.MLManageJobsLink, {
        dataTestSubj: "apmMLManageJobsTextLink",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.mlDescriptionText.mlJobsLinkText', {
        defaultMessage: 'Machine Learning'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), displayMlCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ml_callout.MLCallout, {
    isOnSettingsPage: true,
    onCreateJobClick: () => {
      onAddEnvironments();
    },
    onUpgradeClick: () => {
      if (setupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.UpgradeableJobs) {
        return (0, _create_call_apm_api.callApmApi)('POST /internal/apm/settings/anomaly-detection/update_to_v3', {
          signal: null
        }).then(() => {
          core.notifications.toasts.addSuccess({
            title: _i18n.i18n.translate('xpack.apm.jobsList.updateCompletedToastTitle', {
              defaultMessage: 'Anomaly detection jobs created!'
            }),
            text: _i18n.i18n.translate('xpack.apm.jobsList.updateCompletedToastText', {
              defaultMessage: 'Your new anomaly detection jobs have been created successfully. You will start to see anomaly detection results in the app within minutes. The old jobs have been closed but the results are still available within Machine Learning.'
            })
          });
          onUpdateComplete();
        });
      }
    },
    anomalyDetectionSetupState: setupState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.environments', {
    defaultMessage: 'Environments'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: showLegacyJobs,
    onChange: e => {
      setShowLegacyJobs(e.target.checked);
    },
    label: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.showLegacyJobsCheckboxText', {
      defaultMessage: 'Show legacy jobs'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmJobsListManageJobsButton",
    href: mlManageJobsHref,
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.manageMlJobsButtonText', {
    defaultMessage: 'Manage jobs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.noPermissionAddEnvironmentsTooltipLabel', {
      defaultMessage: "Your user role doesn't have permissions to create jobs"
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmJobsListCreateJobButton",
    fill: true,
    iconType: "plusInCircle",
    onClick: onAddEnvironments,
    isDisabled: !canSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.addEnvironments', {
    defaultMessage: 'Create job'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: getNoItemsMessage({
      status
    }),
    columns: columns,
    items: filteredJobs,
    tableLayout: "auto",
    initialPageSize: 25,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }));
}
function getNoItemsMessage({
  status
}) {
  // loading state
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_state_prompt.LoadingStatePrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 12
      }
    });
  }

  // An unexpected error occurred. Show default error message
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.failedFetchText', {
      defaultMessage: 'Unable to fetch anomaly detection jobs.'
    });
  }

  // no errors occurred
  return _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.emptyListText', {
    defaultMessage: 'No anomaly detection jobs.'
  });
}