"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRowSuggestionsSelect = FormRowSuggestionsSelect;
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _suggestions_select = require("../../../../../shared/suggestions_select");
var _all_option = require("../../../../../../../common/agent_configuration/all_option");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/service_page/form_row_suggestions_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FormRowSuggestionsSelect({
  title,
  fieldName,
  description,
  fieldLabel,
  value,
  allowAll = true,
  onChange,
  dataTestSubj,
  isInvalid,
  error
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 45
      }
    }, title),
    description: description,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: fieldLabel,
    isInvalid: isInvalid,
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: allowAll ? [_all_option.ALL_OPTION] : undefined,
    defaultValue: value ? (0, _all_option.getOptionLabel)(value) : undefined,
    fieldName: fieldName,
    onChange: onChange,
    isClearable: false,
    placeholder: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.service.placeholder', {
      defaultMessage: 'Select Option'
    }),
    dataTestSubj: dataTestSubj,
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    isInvalid: isInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
}