"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentField = EnvironmentField;
exports.ErrorGroupingKeyField = ErrorGroupingKeyField;
exports.IsAboveField = IsAboveField;
exports.ServiceField = ServiceField;
exports.TransactionNameField = TransactionNameField;
exports.TransactionTypeField = TransactionTypeField;
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _apm = require("../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _suggestions_select = require("../../shared/suggestions_select");
var _popover_expression = require("../ui_components/popover_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/utils/fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceField({
  allowAll = true,
  currentValue,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    dataTestSubj: "apmServiceField",
    value: currentValue || _environment_filter_values.allOptionText,
    title: _i18n.i18n.translate('xpack.apm.alerting.fields.service', {
      defaultMessage: 'Service'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: allowAll ? [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }] : undefined,
    customOptionText: _i18n.i18n.translate('xpack.apm.serviceNamesSelectCustomOptionText', {
      defaultMessage: `Add '{searchValue}' as a new service name`
    }),
    defaultValue: currentValue,
    fieldName: _apm.SERVICE_NAME,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.serviceNamesSelectPlaceholder', {
      defaultMessage: 'Select service name'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
}
function EnvironmentField({
  currentValue,
  onChange,
  serviceName
}) {
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    dataTestSubj: "apmEnvironmentField",
    value: (0, _environment_filter_values.getEnvironmentLabel)(currentValue),
    title: _i18n.i18n.translate('xpack.apm.alerting.fields.environment', {
      defaultMessage: 'Environment'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [_environment_filter_values.ENVIRONMENT_ALL],
    customOptionText: _i18n.i18n.translate('xpack.apm.environmentsSelectCustomOptionText', {
      defaultMessage: `Add '{searchValue}' as a new environment`
    }),
    defaultValue: (0, _environment_filter_values.getEnvironmentLabel)(currentValue),
    fieldName: _apm.SERVICE_ENVIRONMENT,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.environmentsSelectPlaceholder', {
      defaultMessage: 'Select environment'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
}
function TransactionNameField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.transaction.name', {
    defaultMessage: 'Name'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    dataTestSubj: "apmTransactionNameField",
    value: currentValue || _environment_filter_values.allOptionText,
    title: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.alerting.transaction.name.custom.text', {
      defaultMessage: `Add '{searchValue}' as a new transaction name`
    }),
    defaultValue: currentValue,
    fieldName: _apm.TRANSACTION_NAME,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.transactionNamesSelectPlaceholder', {
      defaultMessage: 'Select transaction name'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }));
}
function TransactionTypeField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.type', {
    defaultMessage: 'Type'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    dataTestSubj: "apmTransactionTypeField",
    value: currentValue || _environment_filter_values.allOptionText,
    title: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.transactionTypesSelectCustomOptionText', {
      defaultMessage: `Add '{searchValue}' as a new transaction type`
    }),
    defaultValue: currentValue,
    fieldName: _apm.TRANSACTION_TYPE,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.transactionTypesSelectPlaceholder', {
      defaultMessage: 'Select transaction type'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }));
}
function ErrorGroupingKeyField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.error.group.id', {
    defaultMessage: 'Error grouping key'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    dataTestSubj: "apmErrorGroupingKeyField",
    value: currentValue || _environment_filter_values.allOptionText,
    title: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.errorKeySelectCustomOptionText', {
      defaultMessage: `Add '{searchValue}' as a new error grouping key`
    }),
    defaultValue: currentValue,
    fieldName: _apm.ERROR_GROUP_ID,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.errorGroupingKeySelectPlaceholder', {
      defaultMessage: 'Select error grouping key'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }));
}
function isNumeric(value) {
  return !isNaN(Number(value)) && value.trim() !== '';
}
function IsAboveField({
  value,
  unit,
  onChange,
  step
}) {
  const [thresholdPopoverOpen, serThresholdPopoverOpen] = (0, _react.useState)(false);
  const [isAboveValue, setIsAboveValue] = (0, _react.useState)(String(value));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: thresholdPopoverOpen,
    anchorPosition: 'downLeft',
    ownFocus: true,
    closePopover: () => {
      serThresholdPopoverOpen(false);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      value: `${value}${unit}`,
      description: _i18n.i18n.translate('xpack.apm.transactionErrorRateRuleType.isAbove', {
        defaultMessage: 'is above'
      }),
      isInvalid: !isNumeric(isAboveValue),
      isActive: thresholdPopoverOpen,
      onClick: () => {
        serThresholdPopoverOpen(true);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !isNumeric(isAboveValue),
    error: _i18n.i18n.translate('xpack.apm.transactionErrorRateRuleType.error.validThreshold', {
      defaultMessage: 'Thresholds must contain a valid number.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "apmIsAboveFieldFieldNumber",
    min: 0,
    value: isAboveValue,
    onChange: e => {
      const thresholdVal = e.target.value;
      // Update the value to continue typing (if user stopped at . or ,)
      setIsAboveValue(thresholdVal);
      // Only send the value back to the rule if it's a valid number
      if (!isNaN(Number(thresholdVal))) {
        onChange(Number(thresholdVal));
      }
    },
    append: unit,
    isInvalid: !isNumeric(isAboveValue),
    compressed: true,
    step: step,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  })));
}