"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleModelVersions = void 0;
var _raw_rule = require("../schemas/raw_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleModelVersions = exports.ruleModelVersions = {
  '1': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV1.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV1
    }
  },
  '2': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV2.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV2
    }
  },
  '3': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV3.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV3
    }
  },
  '4': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV4.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV4
    }
  },
  '5': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV5.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV5
    }
  },
  '6': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        artifacts: {
          properties: {
            investigation_guide: {
              properties: {
                blob: {
                  type: 'text'
                }
              }
            }
          }
        }
      }
    }],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV6.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV6
    }
  },
  '7': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_rule.rawRuleSchemaV7.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_rule.rawRuleSchemaV7
    }
  }
};