"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInternalRuleType = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateInternalRuleType = ({
  ruleTypeId,
  ruleTypes,
  operationText
}) => {
  const ruleType = ruleTypes.get(ruleTypeId);

  /**
   * Throws a bad request (400) if the rule type is internallyManaged
   * ruleType will always exist here because ruleTypes.get will throw a 400
   * error if the rule type is not registered.
   */
  if (ruleType !== null && ruleType !== void 0 && ruleType.internallyManaged) {
    throw _boom.default.badRequest(`Cannot ${operationText} rule of type "${ruleTypeId}" because it is internally managed.`);
  }
};
exports.validateInternalRuleType = validateInternalRuleType;