"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGapsSearchAfterParamsSchema = exports.findGapsParamsSchema = exports.findGapsByIdParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findGapsBaseParamsSchema = _configSchema.schema.object({
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  perPage: _configSchema.schema.number({
    defaultValue: 10,
    min: 0
  }),
  start: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortField: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('@timestamp'), _configSchema.schema.literal('kibana.alert.rule.gap.total_gap_duration_ms'), _configSchema.schema.literal('kibana.alert.rule.gap.status')])),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_.gapStatusSchema)),
  hasUnfilledIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hasInProgressIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hasFilledIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = start && Date.parse(start);
    const parsedEnd = end && Date.parse(end);
    if (parsedStart && isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    if (parsedEnd && isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
    if (parsedStart && parsedEnd && parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const findGapsParamsSchema = exports.findGapsParamsSchema = findGapsBaseParamsSchema.extends({
  ruleId: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  })
});
const findGapsByIdParamsSchema = exports.findGapsByIdParamsSchema = _configSchema.schema.object({
  gapIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  ruleId: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.number({
    defaultValue: 10,
    min: 1
  })
});
const findGapsSearchAfterParamsSchema = exports.findGapsSearchAfterParamsSchema = findGapsBaseParamsSchema.extends({
  ruleIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  pitId: _configSchema.schema.maybe(_configSchema.schema.string()),
  searchAfter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.any()]))),
  updatedBefore: _configSchema.schema.maybe(_configSchema.schema.string())
});