"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigation = exports.useMaintenanceWindowsNavigation = exports.useEditMaintenanceWindowsNavigation = exports.useCreateMaintenanceWindowNavigation = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/maintenance-windows-plugin/common");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigation = appId => {
  const {
    navigateToApp,
    getUrlForApp
  } = (0, _kibana_react.useKibana)().services.application;
  const navigateTo = (0, _react.useCallback)(options => {
    navigateToApp(appId, options);
  }, [appId, navigateToApp]);
  const getAppUrl = (0, _react.useCallback)(options => getUrlForApp(appId, options), [appId, getUrlForApp]);
  return {
    navigateTo,
    getAppUrl
  };
};
exports.useNavigation = useNavigation;
const useCreateMaintenanceWindowNavigation = () => {
  const {
    navigateTo
  } = useNavigation(_common.MANAGEMENT_APP_ID);
  return {
    navigateToCreateMaintenanceWindow: () => navigateTo({
      path: _common.MAINTENANCE_WINDOW_PATHS.maintenanceWindowsCreate,
      deepLinkId: _common.MAINTENANCE_WINDOWS_APP_ID
    })
  };
};
exports.useCreateMaintenanceWindowNavigation = useCreateMaintenanceWindowNavigation;
const useMaintenanceWindowsNavigation = () => {
  const {
    navigateTo,
    getAppUrl
  } = useNavigation(_common.MANAGEMENT_APP_ID);
  const path = '/';
  const deepLinkId = _common.MAINTENANCE_WINDOWS_APP_ID;
  return {
    navigateToMaintenanceWindows: () => navigateTo({
      path,
      deepLinkId
    }),
    getMaintenanceWindowsUrl: absolute => getAppUrl({
      path,
      deepLinkId,
      absolute
    })
  };
};
exports.useMaintenanceWindowsNavigation = useMaintenanceWindowsNavigation;
const useEditMaintenanceWindowsNavigation = () => {
  const {
    navigateTo,
    getAppUrl
  } = useNavigation(_common.MANAGEMENT_APP_ID);
  const deepLinkId = _common.MAINTENANCE_WINDOWS_APP_ID;
  return {
    navigateToEditMaintenanceWindows: maintenanceWindowId => navigateTo({
      path: (0, _reactRouterDom.generatePath)(_common.MAINTENANCE_WINDOW_PATHS.maintenanceWindowsEdit, {
        maintenanceWindowId
      }),
      deepLinkId
    }),
    getEditMaintenanceWindowsUrl: (maintenanceWindowId, absolute) => getAppUrl({
      path: (0, _reactRouterDom.generatePath)(_common.MAINTENANCE_WINDOW_PATHS.maintenanceWindowsEdit, {
        maintenanceWindowId
      }),
      deepLinkId,
      absolute
    })
  };
};
exports.useEditMaintenanceWindowsNavigation = useEditMaintenanceWindowsNavigation;