"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.muteAlertQuerySchema = exports.muteAlertParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const muteAlertParamsSchema = exports.muteAlertParamsSchema = _configSchema.schema.object({
  rule_id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the rule.'
    }
  }),
  alert_id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the alert.'
    }
  })
});
const muteAlertQuerySchema = exports.muteAlertQuerySchema = _configSchema.schema.maybe(_configSchema.schema.object({
  validate_alerts_existence: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true,
    meta: {
      description: 'Whether to validate the existence of the alert.'
    }
  }))
}));