"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeLogRateAnalysisControls = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeLogRateAnalysisControls = rawState => {
  const dataViewId = new _rxjs.BehaviorSubject(rawState.dataViewId);
  const updateUserInput = update => {
    dataViewId.next(update.dataViewId);
  };
  const serializeLogRateAnalysisChartState = () => {
    return {
      dataViewId: dataViewId.getValue()
    };
  };
  return {
    logRateAnalysisControlsApi: {
      dataViewId,
      updateUserInput
    },
    serializeLogRateAnalysisChartState
  };
};
exports.initializeLogRateAnalysisControls = initializeLogRateAnalysisControls;