"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogCategorizationDiscover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("@kbn/aiops-common/constants");
var _react2 = require("@emotion/react");
var _use_table_state = require("@kbn/ml-in-memory-table/hooks/use_table_state");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _dataService = require("@kbn/data-service");
var _aiopsUtils = require("@kbn/aiops-utils");
var _log_pattern_analysis = require("../../../application/url_state/log_pattern_analysis");
var _use_data = require("../../../hooks/use_data");
var _use_search = require("../../../hooks/use_search");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _use_categorize_request = require("../use_categorize_request");
var _category_table = require("../category_table");
var _information_text = require("../information_text");
var _loading_categorization = require("../loading_categorization");
var _use_validate_category_field = require("../use_validate_category_field");
var _category_validation_callout = require("../category_validation_callout");
var _use_minimum_time_range = require("./use_minimum_time_range");
var _utils = require("../utils");
var _discover_tabs = require("./discover_tabs");
var _sampling_menu = require("../sampling_menu");
var _use_actions = require("../category_table/use_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/log_categorization_for_discover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BAR_TARGET = 20;
const LogCategorizationDiscover = ({
  input,
  renderViewModeToggle
}) => {
  var _documentStats$docume2, _data$categories$leng, _data$categories;
  const {
    notifications: {
      toasts
    },
    data: {
      query: {
        getState,
        filterManager
      }
    },
    uiSettings,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const tablePadding = (0, _eui.useEuiPaddingSize)('xs');
  const {
    dataView,
    savedSearch
  } = input;
  const {
    runValidateFieldRequest,
    cancelRequest: cancelValidationRequest
  } = (0, _use_validate_category_field.useValidateFieldRequest)();
  const {
    getMinimumTimeRange,
    cancelRequest: cancelWiderTimeRangeRequest,
    minimumTimeRangeOption,
    setMinimumTimeRangeOption
  } = (0, _use_minimum_time_range.useMinimumTimeRange)();
  const {
    filters,
    query
  } = (0, _react.useMemo)(() => getState(), [getState]);
  const isMounted = (0, _useMountedState.default)();
  const randomSamplerStorage = (0, _sampling_menu.useRandomSamplerStorage)();
  const {
    runCategorizeRequest,
    cancelRequest: cancelCategorizationRequest,
    randomSampler
  } = (0, _use_categorize_request.useCategorizeRequest)(randomSamplerStorage);
  const [stateFromUrl] = (0, _mlUrlState.usePageUrlState)('logCategorization', (0, _log_pattern_analysis.getDefaultLogCategorizationAppState)({
    searchQuery: (0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined)
  }));
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const [selectedField, setSelectedField] = (0, _react.useState)(null);
  const [fields, setFields] = (0, _react.useState)([]);
  const [currentDocumentStatsHash, setCurrentDocumentStatsHash] = (0, _react.useState)(null);
  const [previousDocumentStatsHash, setPreviousDocumentStatsHash] = (0, _react.useState)(0);
  const [currentAdditionalConfigsHash, setCurrentAdditionalConfigsHash] = (0, _react.useState)(null);
  const [previousAdditionalConfigsHash, setPreviousAdditionalConfigsHash] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(null);
  const [eventRate, setEventRate] = (0, _react.useState)([]);
  const [data, setData] = (0, _react.useState)(null);
  const [fieldValidationResult, setFieldValidationResult] = (0, _react.useState)(null);
  const tableState = (0, _use_table_state.useTableState)([], 'key');
  (0, _react.useEffect)(function initFields() {
    setCurrentDocumentStatsHash(null);
    setSelectedField(null);
    setLoading(null);
    const {
      dataViewFields,
      messageField
    } = (0, _aiopsUtils.getCategorizationDataViewField)(dataView);
    setFields(dataViewFields);
    setSelectedField(messageField);
  }, [dataView]);
  const cancelRequest = (0, _react.useCallback)(() => {
    cancelWiderTimeRangeRequest();
    cancelValidationRequest();
    cancelCategorizationRequest();
  }, [cancelCategorizationRequest, cancelValidationRequest, cancelWiderTimeRangeRequest]);
  (0, _react.useEffect)(function cancelRequestOnLeave() {
    return () => {
      cancelRequest();
    };
  }, [cancelRequest]);
  const {
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch: savedSearch !== null && savedSearch !== void 0 ? savedSearch : null
  }, stateFromUrl, true);
  const {
    documentStats,
    timefilter,
    earliest,
    latest,
    intervalMs,
    forceRefresh
  } = (0, _use_data.useData)(dataView, 'log_categorization', searchQuery, () => {}, undefined, undefined, BAR_TARGET, false);
  const onAddFilter = (0, _react.useCallback)((values, alias) => {
    const filter = (0, _esQuery.buildEmptyFilter)(false, dataView.id);
    if (alias) {
      filter.meta.alias = alias;
    }
    filter.query = values.query;
    if (typeof input.switchToDocumentView === 'function') {
      input.switchToDocumentView().finally(() => {
        filterManager.addFilters([filter]);
      });
    }
  }, [dataView.id, filterManager, input]);
  const {
    getActions,
    openInDiscover
  } = (0, _use_actions.useActions)(dataView.id, selectedField !== null && selectedField !== void 0 ? selectedField : undefined, selectedCategories, stateFromUrl, timefilter, onAddFilter, undefined);
  (0, _react.useEffect)(function createDocumentStatHash() {
    if (documentStats.documentCountStats === undefined) {
      return;
    }
    const hash = (0, _utils.createDocumentStatsHash)(documentStats);
    if (hash !== previousDocumentStatsHash) {
      setCurrentDocumentStatsHash(hash);
      setData(null);
      setFieldValidationResult(null);
    }
  }, [documentStats, previousDocumentStatsHash]);
  (0, _react.useEffect)(function createAdditionalConfigHash2() {
    if (!(selectedField !== null && selectedField !== void 0 && selectedField.name)) {
      return;
    }
    const hash = (0, _utils.createAdditionalConfigHash)([selectedField.name, minimumTimeRangeOption]);
    if (hash !== previousAdditionalConfigsHash) {
      setCurrentAdditionalConfigsHash(hash);
      setData(null);
      setFieldValidationResult(null);
    }
  }, [minimumTimeRangeOption, previousAdditionalConfigsHash, selectedField]);
  const loadCategories = (0, _react.useCallback)(async () => {
    const {
      getIndexPattern,
      timeFieldName: timeField
    } = dataView;
    const index = getIndexPattern();
    if (loading === true || selectedField === null || timeField === undefined || earliest === undefined || latest === undefined || minimumTimeRangeOption === undefined || isMounted() !== true) {
      return;
    }
    cancelRequest();
    setLoading(true);
    setData(null);
    setFieldValidationResult(null);
    const additionalFilter = {
      from: earliest,
      to: latest
    };
    const runtimeMappings = dataView.getRuntimeMappings();
    try {
      const timeRange = await getMinimumTimeRange(index, timeField, additionalFilter, minimumTimeRangeOption, searchQuery, runtimeMappings);
      if (isMounted() === false) {
        return;
      }
      const [validationResult, categorizationResult] = await Promise.all([runValidateFieldRequest(index, selectedField.name, timeField, timeRange, searchQuery, runtimeMappings, {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }), runCategorizeRequest(index, selectedField.name, timeField, {
        to: timeRange.to,
        from: timeRange.from
      }, searchQuery, runtimeMappings, intervalMs, timeRange.useSubAgg ? additionalFilter : undefined)]);
      if (isMounted() === false) {
        return;
      }
      setFieldValidationResult(validationResult);
      const {
        categories,
        hasExamples
      } = categorizationResult;
      if (timeRange.useSubAgg) {
        const categoriesInBucket = categorizationResult.categories.map(category => {
          var _category$subFieldCou;
          return {
            ...category,
            count: (_category$subFieldCou = category.subFieldCount) !== null && _category$subFieldCou !== void 0 ? _category$subFieldCou : category.subTimeRangeCount,
            examples: category.subFieldExamples,
            sparkline: category.subFieldSparkline
          };
        }).filter(category => category.count > 0).sort((a, b) => b.count - a.count);
        setData({
          categories: categoriesInBucket,
          displayExamples: hasExamples,
          totalCategories: categories.length
        });
      } else {
        setData({
          categories,
          displayExamples: hasExamples,
          totalCategories: categories.length
        });
      }
    } catch (error) {
      if (error.name !== 'AbortError') {
        toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.aiops.logCategorization.errorLoadingCategories', {
            defaultMessage: 'Error loading categories'
          })
        });
      }
    }
    if (isMounted() === true) {
      setLoading(false);
    }
  }, [dataView, loading, selectedField, earliest, latest, minimumTimeRangeOption, isMounted, cancelRequest, getMinimumTimeRange, searchQuery, runValidateFieldRequest, embeddingOrigin, runCategorizeRequest, intervalMs, toasts]);
  (0, _react.useEffect)(function triggerAnalysis() {
    var _documentStats$docume;
    const buckets = (_documentStats$docume = documentStats.documentCountStats) === null || _documentStats$docume === void 0 ? void 0 : _documentStats$docume.buckets;
    if (buckets === undefined || currentDocumentStatsHash === null) {
      return;
    }
    if (currentDocumentStatsHash !== previousDocumentStatsHash || currentAdditionalConfigsHash !== previousAdditionalConfigsHash && currentDocumentStatsHash !== null) {
      randomSampler.setDocCount(documentStats.totalCount);
      setEventRate(Object.entries(buckets).map(([key, docCount]) => ({
        key: +key,
        docCount
      })));
      loadCategories();
      setPreviousDocumentStatsHash(currentDocumentStatsHash);
      setPreviousAdditionalConfigsHash(currentAdditionalConfigsHash);
    }
  }, [loadCategories, randomSampler, previousDocumentStatsHash, fieldValidationResult, currentDocumentStatsHash, currentAdditionalConfigsHash, (_documentStats$docume2 = documentStats.documentCountStats) === null || _documentStats$docume2 === void 0 ? void 0 : _documentStats$docume2.buckets, documentStats.totalCount, previousAdditionalConfigsHash]);
  (0, _react.useEffect)(function refreshTriggeredFromButton() {
    if (input.lastReloadRequestTime !== undefined) {
      setPreviousDocumentStatsHash(0);
      setPreviousAdditionalConfigsHash(null);
      forceRefresh();
    }
  },
  // stop infinite loop from forceRefresh dependency
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [input.lastReloadRequestTime]);
  const style = (0, _react2.css)({
    overflowY: 'auto'
  });
  const actions = getActions(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_discover_tabs.DiscoverTabs, {
    data: data,
    fields: fields,
    loadCategories: loadCategories,
    minimumTimeRangeOption: minimumTimeRangeOption,
    openInDiscover: openInDiscover,
    randomSampler: randomSampler,
    selectedCategories: selectedCategories,
    selectedField: selectedField,
    setMinimumTimeRangeOption: setMinimumTimeRangeOption,
    setSelectedField: setSelectedField,
    renderViewModeToggle: renderViewModeToggle,
    dataview: dataView,
    earliest: earliest,
    latest: latest,
    query: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-fullHeight",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      position: 'relative',
      overflowY: 'auto',
      marginLeft: tablePadding
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_category_validation_callout.FieldValidationCallout, {
    validationResults: fieldValidationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 15
    }
  }), (loading !== null && loading !== void 0 ? loading : true) === true ? /*#__PURE__*/_react.default.createElement(_loading_categorization.LoadingCategorization, {
    onCancel: cancelRequest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 17
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_information_text.InformationText, {
    loading: loading !== null && loading !== void 0 ? loading : true,
    categoriesLength: (_data$categories$leng = data === null || data === void 0 ? void 0 : (_data$categories = data.categories) === null || _data$categories === void 0 ? void 0 : _data$categories.length) !== null && _data$categories$leng !== void 0 ? _data$categories$leng : null,
    eventRateLength: eventRate.length,
    fields: fields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 15
    }
  }), loading === false && data !== null && data.categories.length > 0 && selectedField !== null ? /*#__PURE__*/_react.default.createElement(_category_table.CategoryTable, {
    categories: data.categories,
    eventRate: eventRate,
    enableRowActions: false,
    displayExamples: data.displayExamples,
    setSelectedCategories: setSelectedCategories,
    tableState: tableState,
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 17
    }
  }) : null)))));
};

// eslint-disable-next-line import/no-default-export
exports.LogCategorizationDiscover = LogCategorizationDiscover;
var _default = exports.default = LogCategorizationDiscover;