"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _mini_histogram = require("../../mini_histogram");
var _expanded_row = require("./expanded_row");
var _format_category = require("../format_category");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/category_table/category_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategoryTable = ({
  categories,
  eventRate,
  mouseOver,
  setSelectedCategories,
  tableState,
  actions,
  enableRowActions = true,
  displayExamples = true,
  selectable = true,
  onRenderComplete
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const {
    onTableChange,
    pagination,
    sorting
  } = tableState;
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const showSparkline = (0, _react.useMemo)(() => {
    return categories.some(category => category.sparkline !== undefined);
  }, [categories]);
  const toggleDetails = (0, _react.useCallback)(category => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[category.key]) {
      delete itemIdToExpandedRowMapValues[category.key];
    } else {
      itemIdToExpandedRowMapValues[category.key] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        category: category,
        displayExamples: displayExamples,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  }, [displayExamples, itemIdToExpandedRowMap]);
  const columns = [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "aiopsLogPatternsColumnsButton",
      onClick: () => toggleDetails(item),
      "aria-label": itemIdToExpandedRowMap[item.key] ? _i18n.i18n.translate('xpack.aiops.logCategorization.column.collapseRow', {
        defaultMessage: 'Collapse'
      }) : _i18n.i18n.translate('xpack.aiops.logCategorization.column.expandRow', {
        defaultMessage: 'Expand'
      }),
      iconType: itemIdToExpandedRowMap[item.key] ? 'arrowDown' : 'arrowRight',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'aiopsLogPatternsExpandRowToggle'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.count', {
      defaultMessage: 'Count'
    }),
    sortable: true,
    width: '80px'
  }, {
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.examples', {
      defaultMessage: 'Examples'
    }),
    sortable: true,
    render: item => /*#__PURE__*/_react.default.createElement(_format_category.FormattedPatternExamples, {
      category: item,
      count: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 35
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.actions', {
      defaultMessage: 'Actions'
    }),
    sortable: false,
    width: '65px',
    actions
  }];
  if (displayExamples === false) {
    // on the rare occasion that examples are not available, replace the examples column with tokens
    columns.splice(2, 1, {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logCategorization.column.tokens.tooltip', {
          defaultMessage: 'If the selected field is an alias, example documents cannot be displayed. Showing pattern tokens instead.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.aiops.logCategorization.column.tokens', {
        defaultMessage: 'Tokens'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 13
        }
      }))),
      render: item => /*#__PURE__*/_react.default.createElement(_format_category.FormattedTokens, {
        category: item,
        count: 1,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 35
        }
      })
    });
  }
  if (showSparkline === true) {
    columns.splice(2, 0, {
      field: 'sparkline',
      name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.logRate', {
        defaultMessage: 'Log rate'
      }),
      sortable: false,
      width: '100px',
      render: sparkline => {
        if (sparkline === undefined) {
          return null;
        }
        const histogram = eventRate.map(({
          key: catKey,
          docCount
        }) => {
          var _sparkline$catKey;
          const term = (_sparkline$catKey = sparkline[catKey]) !== null && _sparkline$catKey !== void 0 ? _sparkline$catKey : 0;
          const newTerm = term > docCount ? docCount : term;
          const adjustedDocCount = docCount - newTerm;
          return {
            doc_count_overall: adjustedDocCount,
            doc_count_significant_item: newTerm,
            key: catKey,
            key_as_string: `${catKey}`
          };
        });
        return /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
          chartData: histogram,
          isLoading: categories === null && histogram === undefined,
          label: '',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 11
          }
        });
      }
    });
  }
  const selectionValue = selectable ? {
    selectable: () => true,
    onSelectionChange: selectedItems => setSelectedCategories(selectedItems)
  } : undefined;
  const getRowStyle = category => {
    if (mouseOver === undefined) {
      return {};
    }
    if (mouseOver.pinnedCategory && mouseOver.pinnedCategory.key === category.key && mouseOver.pinnedCategory.key === category.key) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (mouseOver.highlightedCategory && mouseOver.highlightedCategory.key === category.key) {
      return {
        backgroundColor: euiTheme.colors.lightestShade
      };
    }
    return {
      backgroundColor: euiTheme.colors.emptyShade
    };
  };
  const tableStyle = (0, _react2.css)({
    thead: {
      position: 'sticky',
      insetBlockStart: 0,
      zIndex: 1,
      backgroundColor: euiTheme.colors.emptyShade,
      boxShadow: `inset 0 0px 0, inset 0 -1px 0 ${euiTheme.border.color}`
    }
  });
  const chartWrapperRef = (0, _react.useRef)(null);
  const renderCompleteListener = (0, _react.useCallback)(event => {
    if (event.target !== chartWrapperRef.current) {
      return;
    }
    if (typeof onRenderComplete === 'function') {
      onRenderComplete();
    }
  }, [onRenderComplete]);
  (0, _react.useEffect)(() => {
    if (!chartWrapperRef.current) {
      throw new Error('Reference to the chart wrapper is not set');
    }
    const chartWrapper = chartWrapperRef.current;
    chartWrapper.addEventListener('renderComplete', renderCompleteListener);
    return () => {
      chartWrapper.removeEventListener('renderComplete', renderCompleteListener);
    };
  }, [renderCompleteListener]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: chartWrapperRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    items: categories,
    columns: columns,
    selection: selectionValue,
    itemId: "key",
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "aiopsLogPatternsTable",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    css: tableStyle,
    rowProps: category => {
      return mouseOver ? {
        onClick: () => {
          var _mouseOver$pinnedCate;
          if (category.key === ((_mouseOver$pinnedCate = mouseOver.pinnedCategory) === null || _mouseOver$pinnedCate === void 0 ? void 0 : _mouseOver$pinnedCate.key)) {
            mouseOver.setPinnedCategory(null);
          } else {
            mouseOver.setPinnedCategory(category);
          }
        },
        onMouseEnter: () => {
          mouseOver.setHighlightedCategory(category);
        },
        onMouseLeave: () => {
          mouseOver.setHighlightedCategory(null);
        },
        style: getRowStyle(category)
      } : undefined;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }));
};
exports.CategoryTable = CategoryTable;