"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLAIN_TEXT_FILE_MICROMATCH_PATTERN = exports.ENCODED_FILE_MICROMATCH_PATTERN = void 0;
Object.defineProperty(exports, "decryptSecurityLabsContent", {
  enumerable: true,
  get: function () {
    return _utils.decryptSecurityLabsContent;
  }
});
Object.defineProperty(exports, "encryptSecurityLabsContent", {
  enumerable: true,
  get: function () {
    return _utils.encryptSecurityLabsContent;
  }
});
var _utils = require("./src/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Micromatch pattern for plain text markdown files in the security labs content.
 */
const PLAIN_TEXT_FILE_MICROMATCH_PATTERN = exports.PLAIN_TEXT_FILE_MICROMATCH_PATTERN = ['*.md', '!*.encoded.md'];

/**
 * Micromatch pattern for encoded markdown files in the security labs content.
 */
const ENCODED_FILE_MICROMATCH_PATTERN = exports.ENCODED_FILE_MICROMATCH_PATTERN = ['*.encoded.md'];