"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBuilderPlatformPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tools = require("./tools");
var _attachment_types = require("./attachment_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentBuilderPlatformPlugin {
  constructor(context) {
    // @ts-expect-error unused for now
    (0, _defineProperty2.default)(this, "logger", void 0);
    // @ts-expect-error unused for now
    (0, _defineProperty2.default)(this, "config", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, setupDeps) {
    (0, _tools.registerTools)({
      coreSetup,
      setupDeps
    });
    (0, _attachment_types.registerAttachmentTypes)({
      coreSetup,
      setupDeps
    });
    return {};
  }
  start(coreStart, startDeps) {
    return {};
  }
  stop() {}
}
exports.AgentBuilderPlatformPlugin = AgentBuilderPlatformPlugin;