"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsqlAttachmentType = void 0;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _attachments = require("@kbn/onechat-common/attachments");
var _tools = require("@kbn/onechat-common/tools");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the definition for the `text` attachment type.
 */
const createEsqlAttachmentType = () => {
  return {
    id: _attachments.AttachmentType.esql,
    validate: async input => {
      const parseResult = _attachments.esqlAttachmentDataSchema.safeParse(input);
      if (!parseResult.success) {
        return {
          valid: false,
          error: parseResult.error.message
        };
      }
      const validationResult = await (0, _esqlValidationAutocomplete.validateQuery)(parseResult.data.query);
      if (validationResult.errors.length > 0) {
        const message = `Query validation returned errors: \n${validationResult.errors.map(error => 'text' in error ? error.text : 'message' in error ? error.message : '').join('\n')}`;
        return {
          valid: false,
          error: message
        };
      }
      return {
        valid: true,
        data: parseResult.data
      };
    },
    format: attachment => {
      return {
        getRepresentation: () => {
          return {
            type: 'text',
            value: formatEsqlAttachment(attachment.data)
          };
        }
      };
    },
    getAgentDescription: () => {
      return `${_attachments.AttachmentType.esql} can be executed using the ${(0, _langchain.sanitizeToolId)(_tools.platformCoreTools.executeEsql)} tool`;
    },
    getTools: () => [_tools.platformCoreTools.executeEsql]
  };
};
exports.createEsqlAttachmentType = createEsqlAttachmentType;
const formatEsqlAttachment = data => {
  let formatted = data.description ? `${data.description}\n` : '';
  formatted += `\`\`\`esql\n${data.query}\n\`\`\``;
  return formatted;
};