"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateExecutorFunction = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function errorResultUnexpectedError(actionId) {
  const errMessage = _i18n.i18n.translate('xpack.actions.singleFileConnector.unexpectedErrorMessage', {
    defaultMessage: 'error calling connector, unexpected error'
  });
  return {
    status: 'error',
    message: errMessage,
    actionId
  };
}
const generateExecutorFunction = ({
  actions,
  getAxiosInstanceWithAuth
}) => async function (execOptions) {
  const {
    actionId: connectorId,
    config,
    connectorTokenClient,
    params,
    secrets,
    logger
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  const axiosInstance = await getAxiosInstanceWithAuth({
    connectorId,
    secrets,
    connectorTokenClient
  });
  if (!actions[subAction]) {
    const errorMessage = `[Action][ExternalService] Unsupported subAction type ${subAction}.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }

  // TODO - we need to update ActionContext in the spec
  const actionContext = {
    log: logger,
    client: axiosInstance,
    secrets,
    config
  };
  try {
    let data = {};
    const res = await actions[subAction].handler(actionContext, subActionParams);
    if (res != null) {
      data = res;
    }
    return {
      status: 'ok',
      data,
      actionId: connectorId
    };
  } catch (error) {
    logger.error(`error on ${connectorId} event: ${error}`);
    return errorResultUnexpectedError(connectorId);
  }
};
exports.generateExecutorFunction = generateExecutorFunction;