"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorFromInMemoryConnector = connectorFromInMemoryConnector;
var _is_connector_deprecated = require("./is_connector_deprecated");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function connectorFromInMemoryConnector({
  id,
  inMemoryConnector,
  actionTypeRegistry
}) {
  const connector = {
    id,
    actionTypeId: inMemoryConnector.actionTypeId,
    name: inMemoryConnector.name,
    isPreconfigured: inMemoryConnector.isPreconfigured,
    isSystemAction: inMemoryConnector.isSystemAction,
    isDeprecated: (0, _is_connector_deprecated.isConnectorDeprecated)(inMemoryConnector),
    isConnectorTypeDeprecated: actionTypeRegistry.isDeprecated(inMemoryConnector.actionTypeId)
  };
  if (inMemoryConnector.exposeConfig) {
    connector.config = inMemoryConnector.config;
  }
  return connector;
}