"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toContainConnectorsFindResult = exports.toContainConnectors = exports.toContainConnector = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toContainConnector = function (actual, expected) {
  const expectedConnector = {
    id: 'test',
    actionTypeId: '.test-connector-type',
    name: 'Test Connector',
    isPreconfigured: false,
    isDeprecated: false,
    isSystemAction: false,
    isConnectorTypeDeprecated: false,
    ...expected
  };
  const pass = this.equals(actual, expectedConnector);
  if (pass) {
    return {
      message: () => `actual connector matches the expected connector`,
      pass: true
    };
  } else {
    return {
      message: () => `expected connector does not match:\n\n${this.utils.printDiffOrStringify(expectedConnector, actual, 'Expected', 'Received', true)}`,
      pass: false
    };
  }
};
exports.toContainConnector = toContainConnector;
const toContainConnectors = function (actual, expected) {
  const actualConnectors = actual;
  const expectedConnectors = expected;
  if (actualConnectors.length !== expectedConnectors.length) {
    return {
      message: () => `Expected ${expectedConnectors.length} connectors, but got ${actualConnectors.length}`,
      pass: false
    };
  }
  for (let i = 0; i < actualConnectors.length; i++) {
    const expectedConnector = expectedConnectors[i];
    const actualConnector = actualConnectors[i];
    const expectedConnectorWithDefaultData = {
      id: 'test',
      actionTypeId: '.test-connector-type',
      name: 'Test Connector',
      isPreconfigured: false,
      isDeprecated: false,
      isSystemAction: false,
      isConnectorTypeDeprecated: false,
      ...expectedConnector
    };
    const pass = this.equals(actualConnector, expectedConnectorWithDefaultData);
    if (!pass) {
      return {
        message: () => `expected connector [index:${i}] does not match:\n\n${this.utils.printDiffOrStringify(expectedConnectorWithDefaultData, actualConnector, 'Expected', 'Received', true)}`,
        pass: false
      };
    }
  }
  return {
    message: () => `All the connectors match the expected connectors`,
    pass: true
  };
};
exports.toContainConnectors = toContainConnectors;
const toContainConnectorsFindResult = function (actual, expected) {
  const actualConnectors = actual;
  const expectedConnectors = expected;
  if (actualConnectors.length !== expectedConnectors.length) {
    return {
      message: () => `Expected ${expectedConnectors.length} connectors, but got ${actualConnectors.length}`,
      pass: false
    };
  }
  for (let i = 0; i < actualConnectors.length; i++) {
    const expectedConnector = expectedConnectors[i];
    const actualConnector = actualConnectors[i];
    const expectedConnectorWithDefaultData = {
      id: 'test',
      actionTypeId: '.test-connector-type',
      name: 'Test Connector',
      isPreconfigured: false,
      isDeprecated: false,
      isSystemAction: false,
      isConnectorTypeDeprecated: false,
      referencedByCount: 0,
      // This is the difference between this and toMatchConnectors
      ...expectedConnector
    };
    const pass = this.equals(actualConnector, expectedConnectorWithDefaultData);
    if (!pass) {
      return {
        message: () => `expected connector [index:${i}] does not match:\n\n${this.utils.printDiffOrStringify(expectedConnectorWithDefaultData, actualConnector, 'Expected', 'Received', true)}`,
        pass: false
      };
    }
  }
  return {
    message: () => `All the connectors match the expected connectors`,
    pass: true
  };
};
exports.toContainConnectorsFindResult = toContainConnectorsFindResult;
expect.extend({
  toContainConnector,
  toContainConnectors,
  toContainConnectorsFindResult
});