"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsConnectorFeatureId = exports.WorkflowsConnectorFeature = exports.UptimeConnectorFeatureId = exports.UptimeConnectorFeature = exports.SecuritySolutionFeature = exports.SecurityConnectorFeatureId = exports.GenerativeAIForSecurityFeature = exports.GenerativeAIForSecurityConnectorFeatureId = exports.GenerativeAIForSearchPlaygroundFeature = exports.GenerativeAIForSearchPlaygroundConnectorFeatureId = exports.GenerativeAIForObservabilityFeature = exports.GenerativeAIForObservabilityConnectorFeatureId = exports.EndpointSecurityConnectorFeatureId = exports.EndpointSecurityConnectorFeature = exports.CasesConnectorFeatureId = exports.CasesConnectorFeature = exports.AlertingConnectorFeatureId = exports.AlertingConnectorFeature = void 0;
exports.areValidFeatures = areValidFeatures;
exports.getConnectorCompatibility = getConnectorCompatibility;
exports.getConnectorFeatureName = getConnectorFeatureName;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertingConnectorFeatureId = exports.AlertingConnectorFeatureId = 'alerting';
const CasesConnectorFeatureId = exports.CasesConnectorFeatureId = 'cases';
const UptimeConnectorFeatureId = exports.UptimeConnectorFeatureId = 'uptime';
const SecurityConnectorFeatureId = exports.SecurityConnectorFeatureId = 'siem';
const GenerativeAIForSecurityConnectorFeatureId = exports.GenerativeAIForSecurityConnectorFeatureId = 'generativeAIForSecurity';
const GenerativeAIForObservabilityConnectorFeatureId = exports.GenerativeAIForObservabilityConnectorFeatureId = 'generativeAIForObservability';
const GenerativeAIForSearchPlaygroundConnectorFeatureId = exports.GenerativeAIForSearchPlaygroundConnectorFeatureId = 'generativeAIForSearchPlayground';
const EndpointSecurityConnectorFeatureId = exports.EndpointSecurityConnectorFeatureId = 'endpointSecurity';
const WorkflowsConnectorFeatureId = exports.WorkflowsConnectorFeatureId = 'workflows';
const compatibilityEndpointSecurity = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.endpointSecurity', {
  defaultMessage: 'Endpoint Security'
});
const compatibilityGenerativeAIForSecurity = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.generativeAIForSecurity', {
  defaultMessage: 'Generative AI for Security'
});
const compatibilityGenerativeAIForObservability = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.generativeAIForObservability', {
  defaultMessage: 'Generative AI for Observability'
});
const compatibilityGenerativeAIForSearchPlayground = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.generativeAIForSearchPlayground', {
  defaultMessage: 'Generative AI for Search'
});
const compatibilityAlertingRules = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.alertingRules', {
  defaultMessage: 'Alerting Rules'
});
const compatibilitySecuritySolution = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.securitySolution', {
  defaultMessage: 'Security Solution'
});
const compatibilityCases = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.cases', {
  defaultMessage: 'Cases'
});
const compatibilityWorkflows = _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.compatibility.workflows', {
  defaultMessage: 'Workflows'
});
const AlertingConnectorFeature = exports.AlertingConnectorFeature = {
  id: AlertingConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.alerting', {
    defaultMessage: 'Alerting'
  }),
  compatibility: compatibilityAlertingRules
};
const CasesConnectorFeature = exports.CasesConnectorFeature = {
  id: CasesConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.cases', {
    defaultMessage: 'Cases'
  }),
  compatibility: compatibilityCases
};
const UptimeConnectorFeature = exports.UptimeConnectorFeature = {
  id: UptimeConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.uptime', {
    defaultMessage: 'Uptime'
  }),
  compatibility: compatibilityAlertingRules
};
const SecuritySolutionFeature = exports.SecuritySolutionFeature = {
  id: SecurityConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.securitySolution', {
    defaultMessage: 'Security Solution'
  }),
  compatibility: compatibilitySecuritySolution
};
const GenerativeAIForSecurityFeature = exports.GenerativeAIForSecurityFeature = {
  id: GenerativeAIForSecurityConnectorFeatureId,
  name: compatibilityGenerativeAIForSecurity,
  compatibility: compatibilityGenerativeAIForSecurity
};
const GenerativeAIForObservabilityFeature = exports.GenerativeAIForObservabilityFeature = {
  id: GenerativeAIForObservabilityConnectorFeatureId,
  name: compatibilityGenerativeAIForObservability,
  compatibility: compatibilityGenerativeAIForObservability
};
const GenerativeAIForSearchPlaygroundFeature = exports.GenerativeAIForSearchPlaygroundFeature = {
  id: GenerativeAIForSearchPlaygroundConnectorFeatureId,
  name: compatibilityGenerativeAIForSearchPlayground,
  compatibility: compatibilityGenerativeAIForSearchPlayground
};
const EndpointSecurityConnectorFeature = exports.EndpointSecurityConnectorFeature = {
  id: EndpointSecurityConnectorFeatureId,
  name: compatibilityEndpointSecurity,
  compatibility: compatibilityEndpointSecurity
};
const WorkflowsConnectorFeature = exports.WorkflowsConnectorFeature = {
  id: WorkflowsConnectorFeatureId,
  name: compatibilityWorkflows,
  compatibility: compatibilityWorkflows
};
const AllAvailableConnectorFeatures = {
  [AlertingConnectorFeature.id]: AlertingConnectorFeature,
  [CasesConnectorFeature.id]: CasesConnectorFeature,
  [UptimeConnectorFeature.id]: UptimeConnectorFeature,
  [SecuritySolutionFeature.id]: SecuritySolutionFeature,
  [GenerativeAIForSecurityFeature.id]: GenerativeAIForSecurityFeature,
  [GenerativeAIForObservabilityFeature.id]: GenerativeAIForObservabilityFeature,
  [GenerativeAIForSearchPlaygroundFeature.id]: GenerativeAIForSearchPlaygroundFeature,
  [EndpointSecurityConnectorFeature.id]: EndpointSecurityConnectorFeature,
  [WorkflowsConnectorFeature.id]: WorkflowsConnectorFeature
};
function areValidFeatures(ids) {
  return ids.every(id => !!AllAvailableConnectorFeatures[id]);
}
function getConnectorFeatureName(id) {
  const featureConfig = AllAvailableConnectorFeatures[id];
  return featureConfig ? featureConfig.name : id;
}
function getConnectorCompatibility(featureIds) {
  const compatibility = new Set();
  if (featureIds && featureIds.length > 0) {
    for (const featureId of featureIds) {
      if (AllAvailableConnectorFeatures[featureId]) {
        compatibility.add(AllAvailableConnectorFeatures[featureId].compatibility);
      }
    }
  }
  return Array.from(compatibility);
}