"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiButton = exports.COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../global_styling/mixins/_button");
var _button_display = require("./button_display/_button_display");
var _react2 = require("@emotion/react");
var _excluded = ["className", "buttonRef", "size", "color", "fill"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var COLORS = exports.COLORS = _button.BUTTON_COLORS;
var SIZES = exports.SIZES = ['s', 'm'];

// For some reason, Storybook doesn't parse `EuiButtonDisplayCommonProps` unless we include it here

/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
var EuiButton = exports.EuiButton = function EuiButton(_ref) {
  var className = _ref.className,
    buttonRef = _ref.buttonRef,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    fill = _ref.fill,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isDisabled = (0, _button_display.isButtonDisabled)({
    href: rest.href,
    isDisabled: rest.isDisabled || rest.disabled,
    isLoading: rest.isLoading
  });
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: fill ? 'fill' : 'base'
  })[isDisabled ? 'disabled' : color];
  var buttonFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var classes = (0, _classnames.default)('euiButton', className);
  var cssStyles = [buttonColorStyles, buttonFocusStyle];
  return (0, _react2.jsx)(_button_display.EuiButtonDisplay, _extends({
    className: classes,
    css: cssStyles,
    ref: buttonRef,
    size: size
  }, rest));
};
EuiButton.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     *
     * Do not use the following colors for standalone buttons directly,
     * they exist to serve other components:
     *  - accent
     *  - warning
     *  - neutral
     *  - risk
     */
  color: _propTypes.default.any,
  /**
     * Use size `s` in confined spaces
     */
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * Controls the disabled behavior via the native `disabled` attribute.
     */
  /**
     * Controls the disabled behavior via the native `disabled` attribute.
     */
  isDisabled: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.bool])]),
  /**
     * NOTE: Beta feature, may be changed or removed in the future
     *
     * Changes the native `disabled` attribute to `aria-disabled` to preserve focusability.
     * This results in a semantically disabled button without the default browser handling of the disabled state.
     *
     * Use e.g. when a disabled button should have a tooltip.
     */
  /**
     * NOTE: Beta feature, may be changed or removed in the future
     *
     * Changes the native `disabled` attribute to `aria-disabled` to preserve focusability.
     * This results in a semantically disabled button without the default browser handling of the disabled state.
     *
     * Use e.g. when a disabled button should have a tooltip.
     */
  hasAriaDisabled: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.bool])]),
  className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string])]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string])]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string])]),
  css: _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.any])]),
  buttonRef: _propTypes.default.any,
  element: _propTypes.default.oneOf(["a", "button", "span"]),
  /**
     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
     * *Only use when the readable text does not change between states.*
     */
  isSelected: _propTypes.default.bool,
  /**
     * Extends the button to 100% width
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Override the default minimum width
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([false])]),
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  isLoading: _propTypes.default.bool,
  /**
     * Object of props passed to the <span/> wrapping the button's content
     */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  style: _propTypes.default.any,
  type: _propTypes.default.any
};