/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlFunctionCall;

public class AcrossSeriesAggregate
extends PromqlFunctionCall {
    private final Grouping grouping;
    private final List<NamedExpression> groupings;
    private final NameId stepId;
    private final NameId valueId;

    public AcrossSeriesAggregate(Source source, LogicalPlan child, String functionName, List<Expression> parameters, Grouping grouping, List<NamedExpression> groupings) {
        this(source, child, functionName, parameters, grouping, groupings, new NameId(), new NameId());
    }

    public AcrossSeriesAggregate(Source source, LogicalPlan child, String functionName, List<Expression> parameters, Grouping grouping, List<NamedExpression> groupings, NameId stepId, NameId valueId) {
        super(source, child, functionName, parameters);
        this.grouping = grouping;
        this.groupings = groupings;
        this.stepId = stepId;
        this.valueId = valueId;
    }

    public Grouping grouping() {
        return this.grouping;
    }

    public List<NamedExpression> groupings() {
        return this.groupings;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && super.expressionsResolved();
    }

    @Override
    protected NodeInfo<PromqlFunctionCall> info() {
        return NodeInfo.create((Node)this, AcrossSeriesAggregate::new, (Object)((Object)this.child()), (Object)this.functionName(), this.parameters(), (Object)((Object)this.grouping()), this.groupings(), (Object)this.stepId(), (Object)this.valueId());
    }

    @Override
    public AcrossSeriesAggregate replaceChild(LogicalPlan newChild) {
        return new AcrossSeriesAggregate(this.source(), newChild, this.functionName(), this.parameters(), this.grouping(), this.groupings(), this.stepId(), this.valueId());
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            AcrossSeriesAggregate that = (AcrossSeriesAggregate)((Object)o);
            return this.grouping == that.grouping && Objects.equals(this.groupings, that.groupings);
        }
        return false;
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = new ArrayList(this.groupings.size() + 2);
            this.output.add(new ReferenceAttribute(this.source(), null, this.sourceText(), DataType.DOUBLE, Nullability.FALSE, this.valueId, false));
            this.output.add(new ReferenceAttribute(this.source(), null, "step", DataType.DATETIME, Nullability.FALSE, this.stepId, false));
            for (NamedExpression exp : this.groupings) {
                this.output.add(exp.toAttribute());
            }
        }
        return this.output;
    }

    public NameId valueId() {
        return this.valueId;
    }

    public NameId stepId() {
        return this.stepId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.grouping, this.groupings});
    }

    public static enum Grouping {
        BY,
        WITHOUT,
        NONE;

    }
}

