/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class ReplaceSourceAttributes
extends PhysicalOptimizerRules.OptimizerRule<EsSourceExec> {
    public ReplaceSourceAttributes() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected PhysicalPlan rule(EsSourceExec plan) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(ReplaceSourceAttributes.getDocAttribute(plan));
        if (plan.indexMode() == IndexMode.TIME_SERIES) {
            for (EsField field : EsQueryExec.TIME_SERIES_SOURCE_FIELDS) {
                attributes.add((Attribute)new FieldAttribute(plan.source(), null, null, field.getName(), field));
            }
        } else {
            for (Attribute attr : plan.output()) {
                MetadataAttribute ma;
                if (!(attr instanceof MetadataAttribute) || !(ma = (MetadataAttribute)attr).name().equals("_score")) continue;
                attributes.add(attr);
                break;
            }
        }
        return new EsQueryExec(plan.source(), plan.indexPattern(), plan.indexMode(), attributes, null, null, null, List.of(new EsQueryExec.QueryBuilderAndTags(plan.query(), List.of())));
    }

    private static Attribute getDocAttribute(EsSourceExec plan) {
        List<Attribute> sourceAttributes = plan.output().stream().filter(EsQueryExec::isDocAttribute).toList();
        if (sourceAttributes.size() > 1) {
            throw new IllegalStateException("Expected at most one source attribute, found: " + String.valueOf(sourceAttributes));
        }
        if (sourceAttributes.isEmpty()) {
            return new FieldAttribute(plan.source(), null, null, EsQueryExec.DOC_ID_FIELD.getName(), EsQueryExec.DOC_ID_FIELD);
        }
        return sourceAttributes.getFirst();
    }
}

