/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.NetworkDirection;

public final class NetworkDirectionEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(NetworkDirectionEvaluator.class);
    private final Source source;
    private final BytesRef scratch;
    private final BytesRef netScratch;
    private final EvalOperator.ExpressionEvaluator sourceIp;
    private final EvalOperator.ExpressionEvaluator destinationIp;
    private final EvalOperator.ExpressionEvaluator networks;
    private final DriverContext driverContext;
    private Warnings warnings;

    public NetworkDirectionEvaluator(Source source, BytesRef scratch, BytesRef netScratch, EvalOperator.ExpressionEvaluator sourceIp, EvalOperator.ExpressionEvaluator destinationIp, EvalOperator.ExpressionEvaluator networks, DriverContext driverContext) {
        this.source = source;
        this.scratch = scratch;
        this.netScratch = netScratch;
        this.sourceIp = sourceIp;
        this.destinationIp = destinationIp;
        this.networks = networks;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.sourceIp.baseRamBytesUsed();
        baseRamBytesUsed += this.destinationIp.baseRamBytesUsed();
        return baseRamBytesUsed += this.networks.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock sourceIpBlock, BytesRefBlock destinationIpBlock, BytesRefBlock networksBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef sourceIpScratch = new BytesRef();
            BytesRef destinationIpScratch = new BytesRef();
            block15: for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                switch (sourceIpBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                switch (destinationIpBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                if (!networksBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                BytesRef sourceIp = sourceIpBlock.getBytesRef(sourceIpBlock.getFirstValueIndex(p), sourceIpScratch);
                BytesRef destinationIp = destinationIpBlock.getBytesRef(destinationIpBlock.getFirstValueIndex(p), destinationIpScratch);
                try {
                    NetworkDirection.process(result, this.scratch, this.netScratch, sourceIp, destinationIp, p, networksBlock);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "NetworkDirectionEvaluator[sourceIp=" + String.valueOf(this.sourceIp) + ", destinationIp=" + String.valueOf(this.destinationIp) + ", networks=" + String.valueOf(this.networks) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.sourceIp, this.destinationIp, this.networks});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BytesRef> scratch;
        private final Function<DriverContext, BytesRef> netScratch;
        private final EvalOperator.ExpressionEvaluator.Factory sourceIp;
        private final EvalOperator.ExpressionEvaluator.Factory destinationIp;
        private final EvalOperator.ExpressionEvaluator.Factory networks;

        public Factory(Source source, Function<DriverContext, BytesRef> scratch, Function<DriverContext, BytesRef> netScratch, EvalOperator.ExpressionEvaluator.Factory sourceIp, EvalOperator.ExpressionEvaluator.Factory destinationIp, EvalOperator.ExpressionEvaluator.Factory networks) {
            this.source = source;
            this.scratch = scratch;
            this.netScratch = netScratch;
            this.sourceIp = sourceIp;
            this.destinationIp = destinationIp;
            this.networks = networks;
        }

        public NetworkDirectionEvaluator get(DriverContext context) {
            return new NetworkDirectionEvaluator(this.source, this.scratch.apply(context), this.netScratch.apply(context), this.sourceIp.get(context), this.destinationIp.get(context), this.networks.get(context), context);
        }

        public String toString() {
            return "NetworkDirectionEvaluator[sourceIp=" + String.valueOf(this.sourceIp) + ", destinationIp=" + String.valueOf(this.destinationIp) + ", networks=" + String.valueOf(this.networks) + "]";
        }
    }
}

