/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffNanosEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffNanosEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator unit;
    private final EvalOperator.ExpressionEvaluator startTimestamp;
    private final EvalOperator.ExpressionEvaluator endTimestamp;
    private final ZoneId zoneId;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffNanosEvaluator(Source source, EvalOperator.ExpressionEvaluator unit, EvalOperator.ExpressionEvaluator startTimestamp, EvalOperator.ExpressionEvaluator endTimestamp, ZoneId zoneId, DriverContext driverContext) {
        this.source = source;
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.zoneId = zoneId;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.unit.baseRamBytesUsed();
        baseRamBytesUsed += this.startTimestamp.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestamp.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, BytesRefBlock unitBlock, LongBlock startTimestampBlock, LongBlock endTimestampBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            block19: for (int p = 0; p < positionCount; ++p) {
                switch (unitBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                switch (startTimestampBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                switch (endTimestampBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                BytesRef unit = unitBlock.getBytesRef(unitBlock.getFirstValueIndex(p), unitScratch);
                long startTimestamp = startTimestampBlock.getLong(startTimestampBlock.getFirstValueIndex(p));
                long endTimestamp = endTimestampBlock.getLong(endTimestampBlock.getFirstValueIndex(p));
                try {
                    result.appendInt(DateDiff.processNanos(unit, startTimestamp, endTimestamp, this.zoneId));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefVector unitVector, LongVector startTimestampVector, LongVector endTimestampVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef unit = unitVector.getBytesRef(p, unitScratch);
                long startTimestamp = startTimestampVector.getLong(p);
                long endTimestamp = endTimestampVector.getLong(p);
                try {
                    result.appendInt(DateDiff.processNanos(unit, startTimestamp, endTimestamp, this.zoneId));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffNanosEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestamp=" + String.valueOf(this.startTimestamp) + ", endTimestamp=" + String.valueOf(this.endTimestamp) + ", zoneId=" + String.valueOf(this.zoneId) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.unit, this.startTimestamp, this.endTimestamp});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory unit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestamp;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestamp;
        private final ZoneId zoneId;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory unit, EvalOperator.ExpressionEvaluator.Factory startTimestamp, EvalOperator.ExpressionEvaluator.Factory endTimestamp, ZoneId zoneId) {
            this.source = source;
            this.unit = unit;
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
            this.zoneId = zoneId;
        }

        public DateDiffNanosEvaluator get(DriverContext context) {
            return new DateDiffNanosEvaluator(this.source, this.unit.get(context), this.startTimestamp.get(context), this.endTimestamp.get(context), this.zoneId, context);
        }

        public String toString() {
            return "DateDiffNanosEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestamp=" + String.valueOf(this.startTimestamp) + ", endTimestamp=" + String.valueOf(this.endTimestamp) + ", zoneId=" + String.valueOf(this.zoneId) + "]";
        }
    }
}

