/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LossySumDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SummationMode;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.ExtractHistogramComponent;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Sum
extends NumericAggregate
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Sum", Sum::new);
    private final Expression summationMode;

    @FunctionInfo(returnType={"long", "double"}, description="The sum of a numeric expression.", type=FunctionType.AGGREGATE, examples={@Example(file="stats", tag="sum"), @Example(description="The expression can use inline functions. For example, to calculate the sum of each employee\u2019s maximum salary changes, apply the `MV_MAX` function to each row and then sum the results", file="stats", tag="docsStatsSumNestedExpression")})
    public Sum(Source source, @Param(name="number", type={"aggregate_metric_double", "exponential_histogram", "double", "integer", "long"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, (Expression)SummationMode.COMPENSATED_LITERAL);
    }

    public Sum(Source source, Expression field, Expression filter, Expression window, Expression summationMode) {
        super(source, field, filter, window, List.of(summationMode));
        this.summationMode = summationMode;
    }

    private Sum(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Sum.readWindow(in), Sum.readSummationMode(in));
    }

    private static Expression readSummationMode(StreamInput in) throws IOException {
        List parameters = in.readNamedWriteableCollectionAsList(Expression.class);
        return parameters.isEmpty() ? SummationMode.COMPENSATED_LITERAL : (Expression)parameters.getFirst();
    }

    public String getWriteableName() {
        return Sum.ENTRY.name;
    }

    protected NodeInfo<? extends Sum> info() {
        return NodeInfo.create((Node)this, Sum::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.summationMode);
    }

    public Sum replaceChildren(List<Expression> newChildren) {
        return new Sum(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Sum withFilter(Expression filter) {
        return new Sum(this.source(), this.field(), filter, this.window(), this.summationMode);
    }

    @Override
    public DataType dataType() {
        DataType dt = this.field().dataType();
        return !dt.isWholeNumber() || dt == DataType.UNSIGNED_LONG ? DataType.DOUBLE : DataType.LONG;
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier() {
        return new SumLongAggregatorFunctionSupplier();
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier() {
        return new SumIntAggregatorFunctionSupplier();
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier() {
        SummationMode mode = SummationMode.fromLiteral(this.summationMode);
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case SummationMode.COMPENSATED -> new SumDoubleAggregatorFunctionSupplier();
            case SummationMode.LOSSY -> new LossySumDoubleAggregatorFunctionSupplier();
        };
    }

    public Expression summationMode() {
        return this.summationMode;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.supportsDates()) {
            return TypeResolutions.isType((Expression)this, e -> e == DataType.DATETIME || e == DataType.AGGREGATE_METRIC_DOUBLE || e == DataType.EXPONENTIAL_HISTOGRAM || e.isNumeric() && e != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"datetime", "aggregate_metric_double, exponential_histogram or numeric except unsigned_long or counter types"});
        }
        return TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.AGGREGATE_METRIC_DOUBLE || dt == DataType.EXPONENTIAL_HISTOGRAM || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"aggregate_metric_double, exponential_histogram or numeric except unsigned_long or counter types"});
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        if (field.dataType() == DataType.AGGREGATE_METRIC_DOUBLE) {
            return new Sum(s, (Expression)FromAggregateMetricDouble.withMetric(this.source(), field, AggregateMetricDoubleBlockBuilder.Metric.SUM), this.filter(), this.window(), this.summationMode);
        }
        if (field.dataType() == DataType.EXPONENTIAL_HISTOGRAM) {
            return new Sum(s, ExtractHistogramComponent.create(this.source(), field, ExponentialHistogramBlock.Component.SUM), this.filter(), this.window(), this.summationMode);
        }
        return field.foldable() ? new Mul(s, (Expression)new MvSum(s, field), (Expression)new Count(s, (Expression)Literal.keyword((Source)s, (String)"*"), this.filter(), this.window())) : null;
    }
}

